<?php

namespace EnumType;

/**
 * This class stands for HotelRoomBookingPricingType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:HotelRoomBookingPricingType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class HotelRoomBookingPricingType
{
    /**
     * Constant for value 'PerRoom'
     * @return string 'PerRoom'
     */
    const VALUE_PER_ROOM = 'PerRoom';
    /**
     * Constant for value 'Bundled'
     * @return string 'Bundled'
     */
    const VALUE_BUNDLED = 'Bundled';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PER_ROOM
     * @uses self::VALUE_BUNDLED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PER_ROOM,
            self::VALUE_BUNDLED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
