<?php

namespace EnumType;

/**
 * This class stands for FeeType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:FeeType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class FeeType
{
    /**
     * Constant for value 'ServiceFee'
     * @return string 'ServiceFee'
     */
    const VALUE_SERVICE_FEE = 'ServiceFee';
    /**
     * Constant for value 'AgencyFee'
     * @return string 'AgencyFee'
     */
    const VALUE_AGENCY_FEE = 'AgencyFee';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SERVICE_FEE
     * @uses self::VALUE_AGENCY_FEE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SERVICE_FEE,
            self::VALUE_AGENCY_FEE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
