<?php

namespace EnumType;

/**
 * This class stands for ExecutionType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ExecutionType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ExecutionType
{
    /**
     * Constant for value 'ToCreate'
     * @return string 'ToCreate'
     */
    const VALUE_TO_CREATE = 'ToCreate';
    /**
     * Constant for value 'ToRemove'
     * @return string 'ToRemove'
     */
    const VALUE_TO_REMOVE = 'ToRemove';
    /**
     * Constant for value 'ToUpdate'
     * @return string 'ToUpdate'
     */
    const VALUE_TO_UPDATE = 'ToUpdate';
    /**
     * Constant for value 'ToGet'
     * @return string 'ToGet'
     */
    const VALUE_TO_GET = 'ToGet';
    /**
     * Constant for value 'ToGetAll'
     * @return string 'ToGetAll'
     */
    const VALUE_TO_GET_ALL = 'ToGetAll';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TO_CREATE
     * @uses self::VALUE_TO_REMOVE
     * @uses self::VALUE_TO_UPDATE
     * @uses self::VALUE_TO_GET
     * @uses self::VALUE_TO_GET_ALL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TO_CREATE,
            self::VALUE_TO_REMOVE,
            self::VALUE_TO_UPDATE,
            self::VALUE_TO_GET,
            self::VALUE_TO_GET_ALL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
