<?php

namespace EnumType;

/**
 * This class stands for DocumentType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DocumentType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class DocumentType
{
    /**
     * Constant for value 'Passport'
     * @return string 'Passport'
     */
    const VALUE_PASSPORT = 'Passport';
    /**
     * Constant for value 'Id'
     * @return string 'Id'
     */
    const VALUE_ID = 'Id';
    /**
     * Constant for value 'DN1'
     * @return string 'DN1'
     */
    const VALUE_DN_1 = 'DN1';
    /**
     * Constant for value 'DN2'
     * @return string 'DN2'
     */
    const VALUE_DN_2 = 'DN2';
    /**
     * Constant for value 'DN3'
     * @return string 'DN3'
     */
    const VALUE_DN_3 = 'DN3';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PASSPORT
     * @uses self::VALUE_ID
     * @uses self::VALUE_DN_1
     * @uses self::VALUE_DN_2
     * @uses self::VALUE_DN_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PASSPORT,
            self::VALUE_ID,
            self::VALUE_DN_1,
            self::VALUE_DN_2,
            self::VALUE_DN_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
