<?php

namespace EnumType;

/**
 * This class stands for DiscountType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DiscountType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class DiscountType
{
    /**
     * Constant for value 'WebDiscount'
     * @return string 'WebDiscount'
     */
    const VALUE_WEB_DISCOUNT = 'WebDiscount';
    /**
     * Constant for value 'FormOfPayment'
     * @return string 'FormOfPayment'
     */
    const VALUE_FORM_OF_PAYMENT = 'FormOfPayment';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WEB_DISCOUNT
     * @uses self::VALUE_FORM_OF_PAYMENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WEB_DISCOUNT,
            self::VALUE_FORM_OF_PAYMENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
