<?php

namespace EnumType;

/**
 * This class stands for CategoryType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CategoryType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class CategoryType
{
    /**
     * Constant for value 'NA'
     * @return string 'NA'
     */
    const VALUE_NA = 'NA';
    /**
     * Constant for value 'One'
     * @return string 'One'
     */
    const VALUE_ONE = 'One';
    /**
     * Constant for value 'OneHalf'
     * @return string 'OneHalf'
     */
    const VALUE_ONE_HALF = 'OneHalf';
    /**
     * Constant for value 'Two'
     * @return string 'Two'
     */
    const VALUE_TWO = 'Two';
    /**
     * Constant for value 'TwoHalf'
     * @return string 'TwoHalf'
     */
    const VALUE_TWO_HALF = 'TwoHalf';
    /**
     * Constant for value 'Three'
     * @return string 'Three'
     */
    const VALUE_THREE = 'Three';
    /**
     * Constant for value 'ThreeHalf'
     * @return string 'ThreeHalf'
     */
    const VALUE_THREE_HALF = 'ThreeHalf';
    /**
     * Constant for value 'Four'
     * @return string 'Four'
     */
    const VALUE_FOUR = 'Four';
    /**
     * Constant for value 'FourHalf'
     * @return string 'FourHalf'
     */
    const VALUE_FOUR_HALF = 'FourHalf';
    /**
     * Constant for value 'Five'
     * @return string 'Five'
     */
    const VALUE_FIVE = 'Five';
    /**
     * Constant for value 'FiveHalf'
     * @return string 'FiveHalf'
     */
    const VALUE_FIVE_HALF = 'FiveHalf';
    /**
     * Constant for value 'Six'
     * @return string 'Six'
     */
    const VALUE_SIX = 'Six';
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NA
     * @uses self::VALUE_ONE
     * @uses self::VALUE_ONE_HALF
     * @uses self::VALUE_TWO
     * @uses self::VALUE_TWO_HALF
     * @uses self::VALUE_THREE
     * @uses self::VALUE_THREE_HALF
     * @uses self::VALUE_FOUR
     * @uses self::VALUE_FOUR_HALF
     * @uses self::VALUE_FIVE
     * @uses self::VALUE_FIVE_HALF
     * @uses self::VALUE_SIX
     * @uses self::VALUE_ALL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NA,
            self::VALUE_ONE,
            self::VALUE_ONE_HALF,
            self::VALUE_TWO,
            self::VALUE_TWO_HALF,
            self::VALUE_THREE,
            self::VALUE_THREE_HALF,
            self::VALUE_FOUR,
            self::VALUE_FOUR_HALF,
            self::VALUE_FIVE,
            self::VALUE_FIVE_HALF,
            self::VALUE_SIX,
            self::VALUE_ALL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
