<?php

namespace EnumType;

/**
 * This class stands for BusinessUnitType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BusinessUnitType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class BusinessUnitType
{
    /**
     * Constant for value 'Corporate'
     * @return string 'Corporate'
     */
    const VALUE_CORPORATE = 'Corporate';
    /**
     * Constant for value 'Retail'
     * @return string 'Retail'
     */
    const VALUE_RETAIL = 'Retail';
    /**
     * Constant for value 'Wholesaler'
     * @return string 'Wholesaler'
     */
    const VALUE_WHOLESALER = 'Wholesaler';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CORPORATE
     * @uses self::VALUE_RETAIL
     * @uses self::VALUE_WHOLESALER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CORPORATE,
            self::VALUE_RETAIL,
            self::VALUE_WHOLESALER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
