<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRoomTypeDefinition ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRoomTypeDefinition
 * @subpackage Arrays
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ArrayOfRoomTypeDefinition extends AbstractStructArrayBase
{
    /**
     * The RoomTypeDefinition
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RoomTypeDefinition[]
     */
    public $RoomTypeDefinition;
    /**
     * Constructor method for ArrayOfRoomTypeDefinition
     * @uses ArrayOfRoomTypeDefinition::setRoomTypeDefinition()
     * @param \StructType\RoomTypeDefinition[] $roomTypeDefinition
     */
    public function __construct(array $roomTypeDefinition = array())
    {
        $this
            ->setRoomTypeDefinition($roomTypeDefinition);
    }
    /**
     * Get RoomTypeDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RoomTypeDefinition[]|null
     */
    public function getRoomTypeDefinition()
    {
        return isset($this->RoomTypeDefinition) ? $this->RoomTypeDefinition : null;
    }
    /**
     * Set RoomTypeDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RoomTypeDefinition[] $roomTypeDefinition
     * @return \ArrayType\ArrayOfRoomTypeDefinition
     */
    public function setRoomTypeDefinition(array $roomTypeDefinition = array())
    {
        foreach ($roomTypeDefinition as $arrayOfRoomTypeDefinitionRoomTypeDefinitionItem) {
            // validation for constraint: itemType
            if (!$arrayOfRoomTypeDefinitionRoomTypeDefinitionItem instanceof \StructType\RoomTypeDefinition) {
                throw new \InvalidArgumentException(sprintf('The RoomTypeDefinition property can only contain items of \StructType\RoomTypeDefinition, "%s" given', is_object($arrayOfRoomTypeDefinitionRoomTypeDefinitionItem) ? get_class($arrayOfRoomTypeDefinitionRoomTypeDefinitionItem) : gettype($arrayOfRoomTypeDefinitionRoomTypeDefinitionItem)), __LINE__);
            }
        }
        if (is_null($roomTypeDefinition) || (is_array($roomTypeDefinition) && empty($roomTypeDefinition))) {
            unset($this->RoomTypeDefinition);
        } else {
            $this->RoomTypeDefinition = $roomTypeDefinition;
        }
        return $this;
    }
    /**
     * Add item to RoomTypeDefinition value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomTypeDefinition $item
     * @return \ArrayType\ArrayOfRoomTypeDefinition
     */
    public function addToRoomTypeDefinition(\StructType\RoomTypeDefinition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomTypeDefinition) {
            throw new \InvalidArgumentException(sprintf('The RoomTypeDefinition property can only contain items of \StructType\RoomTypeDefinition, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoomTypeDefinition[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RoomTypeDefinition|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RoomTypeDefinition|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RoomTypeDefinition|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RoomTypeDefinition|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RoomTypeDefinition|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RoomTypeDefinition
     */
    public function getAttributeName()
    {
        return 'RoomTypeDefinition';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRoomTypeDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
