<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfReservationItemTravelerDefinition ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfReservationItemTravelerDefinition
 * @subpackage Arrays
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ArrayOfReservationItemTravelerDefinition extends AbstractStructArrayBase
{
    /**
     * The ReservationItemTravelerDefinition
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ReservationItemTravelerDefinition[]
     */
    public $ReservationItemTravelerDefinition;
    /**
     * Constructor method for ArrayOfReservationItemTravelerDefinition
     * @uses ArrayOfReservationItemTravelerDefinition::setReservationItemTravelerDefinition()
     * @param \StructType\ReservationItemTravelerDefinition[] $reservationItemTravelerDefinition
     */
    public function __construct(array $reservationItemTravelerDefinition = array())
    {
        $this
            ->setReservationItemTravelerDefinition($reservationItemTravelerDefinition);
    }
    /**
     * Get ReservationItemTravelerDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ReservationItemTravelerDefinition[]|null
     */
    public function getReservationItemTravelerDefinition()
    {
        return isset($this->ReservationItemTravelerDefinition) ? $this->ReservationItemTravelerDefinition : null;
    }
    /**
     * Set ReservationItemTravelerDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ReservationItemTravelerDefinition[] $reservationItemTravelerDefinition
     * @return \ArrayType\ArrayOfReservationItemTravelerDefinition
     */
    public function setReservationItemTravelerDefinition(array $reservationItemTravelerDefinition = array())
    {
        foreach ($reservationItemTravelerDefinition as $arrayOfReservationItemTravelerDefinitionReservationItemTravelerDefinitionItem) {
            // validation for constraint: itemType
            if (!$arrayOfReservationItemTravelerDefinitionReservationItemTravelerDefinitionItem instanceof \StructType\ReservationItemTravelerDefinition) {
                throw new \InvalidArgumentException(sprintf('The ReservationItemTravelerDefinition property can only contain items of \StructType\ReservationItemTravelerDefinition, "%s" given', is_object($arrayOfReservationItemTravelerDefinitionReservationItemTravelerDefinitionItem) ? get_class($arrayOfReservationItemTravelerDefinitionReservationItemTravelerDefinitionItem) : gettype($arrayOfReservationItemTravelerDefinitionReservationItemTravelerDefinitionItem)), __LINE__);
            }
        }
        if (is_null($reservationItemTravelerDefinition) || (is_array($reservationItemTravelerDefinition) && empty($reservationItemTravelerDefinition))) {
            unset($this->ReservationItemTravelerDefinition);
        } else {
            $this->ReservationItemTravelerDefinition = $reservationItemTravelerDefinition;
        }
        return $this;
    }
    /**
     * Add item to ReservationItemTravelerDefinition value
     * @throws \InvalidArgumentException
     * @param \StructType\ReservationItemTravelerDefinition $item
     * @return \ArrayType\ArrayOfReservationItemTravelerDefinition
     */
    public function addToReservationItemTravelerDefinition(\StructType\ReservationItemTravelerDefinition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReservationItemTravelerDefinition) {
            throw new \InvalidArgumentException(sprintf('The ReservationItemTravelerDefinition property can only contain items of \StructType\ReservationItemTravelerDefinition, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ReservationItemTravelerDefinition[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ReservationItemTravelerDefinition|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ReservationItemTravelerDefinition|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ReservationItemTravelerDefinition|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ReservationItemTravelerDefinition|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ReservationItemTravelerDefinition|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ReservationItemTravelerDefinition
     */
    public function getAttributeName()
    {
        return 'ReservationItemTravelerDefinition';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfReservationItemTravelerDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
