<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductTaxDefinition ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfProductTaxDefinition
 * @subpackage Arrays
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ArrayOfProductTaxDefinition extends AbstractStructArrayBase
{
    /**
     * The ProductTaxDefinition
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductTaxDefinition[]
     */
    public $ProductTaxDefinition;
    /**
     * Constructor method for ArrayOfProductTaxDefinition
     * @uses ArrayOfProductTaxDefinition::setProductTaxDefinition()
     * @param \StructType\ProductTaxDefinition[] $productTaxDefinition
     */
    public function __construct(array $productTaxDefinition = array())
    {
        $this
            ->setProductTaxDefinition($productTaxDefinition);
    }
    /**
     * Get ProductTaxDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductTaxDefinition[]|null
     */
    public function getProductTaxDefinition()
    {
        return isset($this->ProductTaxDefinition) ? $this->ProductTaxDefinition : null;
    }
    /**
     * Set ProductTaxDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductTaxDefinition[] $productTaxDefinition
     * @return \ArrayType\ArrayOfProductTaxDefinition
     */
    public function setProductTaxDefinition(array $productTaxDefinition = array())
    {
        foreach ($productTaxDefinition as $arrayOfProductTaxDefinitionProductTaxDefinitionItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductTaxDefinitionProductTaxDefinitionItem instanceof \StructType\ProductTaxDefinition) {
                throw new \InvalidArgumentException(sprintf('The ProductTaxDefinition property can only contain items of \StructType\ProductTaxDefinition, "%s" given', is_object($arrayOfProductTaxDefinitionProductTaxDefinitionItem) ? get_class($arrayOfProductTaxDefinitionProductTaxDefinitionItem) : gettype($arrayOfProductTaxDefinitionProductTaxDefinitionItem)), __LINE__);
            }
        }
        if (is_null($productTaxDefinition) || (is_array($productTaxDefinition) && empty($productTaxDefinition))) {
            unset($this->ProductTaxDefinition);
        } else {
            $this->ProductTaxDefinition = $productTaxDefinition;
        }
        return $this;
    }
    /**
     * Add item to ProductTaxDefinition value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductTaxDefinition $item
     * @return \ArrayType\ArrayOfProductTaxDefinition
     */
    public function addToProductTaxDefinition(\StructType\ProductTaxDefinition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductTaxDefinition) {
            throw new \InvalidArgumentException(sprintf('The ProductTaxDefinition property can only contain items of \StructType\ProductTaxDefinition, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductTaxDefinition[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductTaxDefinition|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductTaxDefinition|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductTaxDefinition|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductTaxDefinition|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductTaxDefinition|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductTaxDefinition
     */
    public function getAttributeName()
    {
        return 'ProductTaxDefinition';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfProductTaxDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
