<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDataDefinition ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDataDefinition
 * @subpackage Arrays
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ArrayOfDataDefinition extends AbstractStructArrayBase
{
    /**
     * The DataDefinition
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DataDefinition[]
     */
    public $DataDefinition;
    /**
     * Constructor method for ArrayOfDataDefinition
     * @uses ArrayOfDataDefinition::setDataDefinition()
     * @param \StructType\DataDefinition[] $dataDefinition
     */
    public function __construct(array $dataDefinition = array())
    {
        $this
            ->setDataDefinition($dataDefinition);
    }
    /**
     * Get DataDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DataDefinition[]|null
     */
    public function getDataDefinition()
    {
        return isset($this->DataDefinition) ? $this->DataDefinition : null;
    }
    /**
     * Set DataDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DataDefinition[] $dataDefinition
     * @return \ArrayType\ArrayOfDataDefinition
     */
    public function setDataDefinition(array $dataDefinition = array())
    {
        foreach ($dataDefinition as $arrayOfDataDefinitionDataDefinitionItem) {
            // validation for constraint: itemType
            if (!$arrayOfDataDefinitionDataDefinitionItem instanceof \StructType\DataDefinition) {
                throw new \InvalidArgumentException(sprintf('The DataDefinition property can only contain items of \StructType\DataDefinition, "%s" given', is_object($arrayOfDataDefinitionDataDefinitionItem) ? get_class($arrayOfDataDefinitionDataDefinitionItem) : gettype($arrayOfDataDefinitionDataDefinitionItem)), __LINE__);
            }
        }
        if (is_null($dataDefinition) || (is_array($dataDefinition) && empty($dataDefinition))) {
            unset($this->DataDefinition);
        } else {
            $this->DataDefinition = $dataDefinition;
        }
        return $this;
    }
    /**
     * Add item to DataDefinition value
     * @throws \InvalidArgumentException
     * @param \StructType\DataDefinition $item
     * @return \ArrayType\ArrayOfDataDefinition
     */
    public function addToDataDefinition(\StructType\DataDefinition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DataDefinition) {
            throw new \InvalidArgumentException(sprintf('The DataDefinition property can only contain items of \StructType\DataDefinition, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DataDefinition[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DataDefinition|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DataDefinition|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DataDefinition|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DataDefinition|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DataDefinition|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DataDefinition
     */
    public function getAttributeName()
    {
        return 'DataDefinition';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDataDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
