<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfileEmailDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProfileEmailDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ProfileEmailDefinition extends AbstractStructBase
{
    /**
     * The ActionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActionType;
    /**
     * The ContactType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ContactType;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailAddress;
    /**
     * The EmailId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EmailId;
    /**
     * The EmailNotifications
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EmailNotifications;
    /**
     * The ProfileId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProfileId;
    /**
     * Constructor method for ProfileEmailDefinition
     * @uses ProfileEmailDefinition::setActionType()
     * @uses ProfileEmailDefinition::setContactType()
     * @uses ProfileEmailDefinition::setEmailAddress()
     * @uses ProfileEmailDefinition::setEmailId()
     * @uses ProfileEmailDefinition::setEmailNotifications()
     * @uses ProfileEmailDefinition::setProfileId()
     * @param string $actionType
     * @param string $contactType
     * @param string $emailAddress
     * @param int $emailId
     * @param bool $emailNotifications
     * @param int $profileId
     */
    public function __construct($actionType = null, $contactType = null, $emailAddress = null, $emailId = null, $emailNotifications = null, $profileId = null)
    {
        $this
            ->setActionType($actionType)
            ->setContactType($contactType)
            ->setEmailAddress($emailAddress)
            ->setEmailId($emailId)
            ->setEmailNotifications($emailNotifications)
            ->setProfileId($profileId);
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\ProfileEmailDefinition
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $actionType, implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get ContactType value
     * @return string|null
     */
    public function getContactType()
    {
        return $this->ContactType;
    }
    /**
     * Set ContactType value
     * @uses \EnumType\ProfileContactType::valueIsValid()
     * @uses \EnumType\ProfileContactType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contactType
     * @return \StructType\ProfileEmailDefinition
     */
    public function setContactType($contactType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProfileContactType::valueIsValid($contactType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $contactType, implode(', ', \EnumType\ProfileContactType::getValidValues())), __LINE__);
        }
        $this->ContactType = $contactType;
        return $this;
    }
    /**
     * Get EmailAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailAddress()
    {
        return isset($this->EmailAddress) ? $this->EmailAddress : null;
    }
    /**
     * Set EmailAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailAddress
     * @return \StructType\ProfileEmailDefinition
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        if (is_null($emailAddress) || (is_array($emailAddress) && empty($emailAddress))) {
            unset($this->EmailAddress);
        } else {
            $this->EmailAddress = $emailAddress;
        }
        return $this;
    }
    /**
     * Get EmailId value
     * @return int|null
     */
    public function getEmailId()
    {
        return $this->EmailId;
    }
    /**
     * Set EmailId value
     * @param int $emailId
     * @return \StructType\ProfileEmailDefinition
     */
    public function setEmailId($emailId = null)
    {
        // validation for constraint: int
        if (!is_null($emailId) && !is_numeric($emailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($emailId)), __LINE__);
        }
        $this->EmailId = $emailId;
        return $this;
    }
    /**
     * Get EmailNotifications value
     * @return bool|null
     */
    public function getEmailNotifications()
    {
        return $this->EmailNotifications;
    }
    /**
     * Set EmailNotifications value
     * @param bool $emailNotifications
     * @return \StructType\ProfileEmailDefinition
     */
    public function setEmailNotifications($emailNotifications = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailNotifications) && !is_bool($emailNotifications)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($emailNotifications)), __LINE__);
        }
        $this->EmailNotifications = $emailNotifications;
        return $this;
    }
    /**
     * Get ProfileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->ProfileId;
    }
    /**
     * Set ProfileId value
     * @param int $profileId
     * @return \StructType\ProfileEmailDefinition
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !is_numeric($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileId)), __LINE__);
        }
        $this->ProfileId = $profileId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProfileEmailDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
