<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelRoomBookingDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:HotelRoomBookingDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class HotelRoomBookingDefinition extends ReservationItemDefinition
{
    /**
     * The AvailToken
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvailToken;
    /**
     * The BookingSource
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingSource;
    /**
     * The BookingSourceNetSuite
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingSourceNetSuite;
    /**
     * The BookingTimeLimit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BookingTimeLimit;
    /**
     * The CancellationPolicies
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfHotelCancellationPolicyDefinition
     */
    public $CancellationPolicies;
    /**
     * The ClientCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientCode;
    /**
     * The Contract
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HotelContractDefinition
     */
    public $Contract;
    /**
     * The Cost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CostDefinition
     */
    public $Cost;
    /**
     * The CreationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreationDate;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The CustomArgument1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomArgument1;
    /**
     * The DateFrom
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DateFrom;
    /**
     * The DateTo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DateTo;
    /**
     * The Destination
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HotelDestinationDefinition
     */
    public $Destination;
    /**
     * The ExtendedSupplierInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedSupplierInfo;
    /**
     * The FileNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileNumber;
    /**
     * The HotelCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HotelId;
    /**
     * The HotelInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HotelInformationDefinition
     */
    public $HotelInformation;
    /**
     * The HotelName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HotelName;
    /**
     * The IsCombined
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsCombined;
    /**
     * The MustBePaidBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MustBePaidBy;
    /**
     * The PaymentStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaymentStatus;
    /**
     * The PricingType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PricingType;
    /**
     * The ProductPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductPriceDefinition
     */
    public $ProductPrice;
    /**
     * The ReservationTracer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfHotelReservationTracerDefinition
     */
    public $ReservationTracer;
    /**
     * The Rooms
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRoomOptionDefinition
     */
    public $Rooms;
    /**
     * The ServiceProviderReferenceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceProviderReferenceCode;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The StatusConfirm
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StatusConfirm;
    /**
     * The ThirdPartySupplier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HotelSupplierDefinition
     */
    public $ThirdPartySupplier;
    /**
     * Constructor method for HotelRoomBookingDefinition
     * @uses HotelRoomBookingDefinition::setAvailToken()
     * @uses HotelRoomBookingDefinition::setBookingSource()
     * @uses HotelRoomBookingDefinition::setBookingSourceNetSuite()
     * @uses HotelRoomBookingDefinition::setBookingTimeLimit()
     * @uses HotelRoomBookingDefinition::setCancellationPolicies()
     * @uses HotelRoomBookingDefinition::setClientCode()
     * @uses HotelRoomBookingDefinition::setContract()
     * @uses HotelRoomBookingDefinition::setCost()
     * @uses HotelRoomBookingDefinition::setCreationDate()
     * @uses HotelRoomBookingDefinition::setCurrencyCode()
     * @uses HotelRoomBookingDefinition::setCustomArgument1()
     * @uses HotelRoomBookingDefinition::setDateFrom()
     * @uses HotelRoomBookingDefinition::setDateTo()
     * @uses HotelRoomBookingDefinition::setDestination()
     * @uses HotelRoomBookingDefinition::setExtendedSupplierInfo()
     * @uses HotelRoomBookingDefinition::setFileNumber()
     * @uses HotelRoomBookingDefinition::setHotelCode()
     * @uses HotelRoomBookingDefinition::setHotelId()
     * @uses HotelRoomBookingDefinition::setHotelInformation()
     * @uses HotelRoomBookingDefinition::setHotelName()
     * @uses HotelRoomBookingDefinition::setIsCombined()
     * @uses HotelRoomBookingDefinition::setMustBePaidBy()
     * @uses HotelRoomBookingDefinition::setPaymentStatus()
     * @uses HotelRoomBookingDefinition::setPricingType()
     * @uses HotelRoomBookingDefinition::setProductPrice()
     * @uses HotelRoomBookingDefinition::setReservationTracer()
     * @uses HotelRoomBookingDefinition::setRooms()
     * @uses HotelRoomBookingDefinition::setServiceProviderReferenceCode()
     * @uses HotelRoomBookingDefinition::setStatus()
     * @uses HotelRoomBookingDefinition::setStatusConfirm()
     * @uses HotelRoomBookingDefinition::setThirdPartySupplier()
     * @param string $availToken
     * @param string $bookingSource
     * @param string $bookingSourceNetSuite
     * @param string $bookingTimeLimit
     * @param \ArrayType\ArrayOfHotelCancellationPolicyDefinition $cancellationPolicies
     * @param string $clientCode
     * @param \StructType\HotelContractDefinition $contract
     * @param \StructType\CostDefinition $cost
     * @param string $creationDate
     * @param string $currencyCode
     * @param string $customArgument1
     * @param string $dateFrom
     * @param string $dateTo
     * @param \StructType\HotelDestinationDefinition $destination
     * @param string $extendedSupplierInfo
     * @param string $fileNumber
     * @param string $hotelCode
     * @param int $hotelId
     * @param \StructType\HotelInformationDefinition $hotelInformation
     * @param string $hotelName
     * @param bool $isCombined
     * @param string $mustBePaidBy
     * @param string $paymentStatus
     * @param string $pricingType
     * @param \StructType\ProductPriceDefinition $productPrice
     * @param \ArrayType\ArrayOfHotelReservationTracerDefinition $reservationTracer
     * @param \ArrayType\ArrayOfRoomOptionDefinition $rooms
     * @param string $serviceProviderReferenceCode
     * @param string $status
     * @param string $statusConfirm
     * @param \StructType\HotelSupplierDefinition $thirdPartySupplier
     */
    public function __construct($availToken = null, $bookingSource = null, $bookingSourceNetSuite = null, $bookingTimeLimit = null, \ArrayType\ArrayOfHotelCancellationPolicyDefinition $cancellationPolicies = null, $clientCode = null, \StructType\HotelContractDefinition $contract = null, \StructType\CostDefinition $cost = null, $creationDate = null, $currencyCode = null, $customArgument1 = null, $dateFrom = null, $dateTo = null, \StructType\HotelDestinationDefinition $destination = null, $extendedSupplierInfo = null, $fileNumber = null, $hotelCode = null, $hotelId = null, \StructType\HotelInformationDefinition $hotelInformation = null, $hotelName = null, $isCombined = null, $mustBePaidBy = null, $paymentStatus = null, $pricingType = null, \StructType\ProductPriceDefinition $productPrice = null, \ArrayType\ArrayOfHotelReservationTracerDefinition $reservationTracer = null, \ArrayType\ArrayOfRoomOptionDefinition $rooms = null, $serviceProviderReferenceCode = null, $status = null, $statusConfirm = null, \StructType\HotelSupplierDefinition $thirdPartySupplier = null)
    {
        $this
            ->setAvailToken($availToken)
            ->setBookingSource($bookingSource)
            ->setBookingSourceNetSuite($bookingSourceNetSuite)
            ->setBookingTimeLimit($bookingTimeLimit)
            ->setCancellationPolicies($cancellationPolicies)
            ->setClientCode($clientCode)
            ->setContract($contract)
            ->setCost($cost)
            ->setCreationDate($creationDate)
            ->setCurrencyCode($currencyCode)
            ->setCustomArgument1($customArgument1)
            ->setDateFrom($dateFrom)
            ->setDateTo($dateTo)
            ->setDestination($destination)
            ->setExtendedSupplierInfo($extendedSupplierInfo)
            ->setFileNumber($fileNumber)
            ->setHotelCode($hotelCode)
            ->setHotelId($hotelId)
            ->setHotelInformation($hotelInformation)
            ->setHotelName($hotelName)
            ->setIsCombined($isCombined)
            ->setMustBePaidBy($mustBePaidBy)
            ->setPaymentStatus($paymentStatus)
            ->setPricingType($pricingType)
            ->setProductPrice($productPrice)
            ->setReservationTracer($reservationTracer)
            ->setRooms($rooms)
            ->setServiceProviderReferenceCode($serviceProviderReferenceCode)
            ->setStatus($status)
            ->setStatusConfirm($statusConfirm)
            ->setThirdPartySupplier($thirdPartySupplier);
    }
    /**
     * Get AvailToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailToken()
    {
        return isset($this->AvailToken) ? $this->AvailToken : null;
    }
    /**
     * Set AvailToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availToken
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setAvailToken($availToken = null)
    {
        // validation for constraint: string
        if (!is_null($availToken) && !is_string($availToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($availToken)), __LINE__);
        }
        if (is_null($availToken) || (is_array($availToken) && empty($availToken))) {
            unset($this->AvailToken);
        } else {
            $this->AvailToken = $availToken;
        }
        return $this;
    }
    /**
     * Get BookingSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingSource()
    {
        return isset($this->BookingSource) ? $this->BookingSource : null;
    }
    /**
     * Set BookingSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingSource
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setBookingSource($bookingSource = null)
    {
        // validation for constraint: string
        if (!is_null($bookingSource) && !is_string($bookingSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingSource)), __LINE__);
        }
        if (is_null($bookingSource) || (is_array($bookingSource) && empty($bookingSource))) {
            unset($this->BookingSource);
        } else {
            $this->BookingSource = $bookingSource;
        }
        return $this;
    }
    /**
     * Get BookingSourceNetSuite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingSourceNetSuite()
    {
        return isset($this->BookingSourceNetSuite) ? $this->BookingSourceNetSuite : null;
    }
    /**
     * Set BookingSourceNetSuite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingSourceNetSuite
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setBookingSourceNetSuite($bookingSourceNetSuite = null)
    {
        // validation for constraint: string
        if (!is_null($bookingSourceNetSuite) && !is_string($bookingSourceNetSuite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingSourceNetSuite)), __LINE__);
        }
        if (is_null($bookingSourceNetSuite) || (is_array($bookingSourceNetSuite) && empty($bookingSourceNetSuite))) {
            unset($this->BookingSourceNetSuite);
        } else {
            $this->BookingSourceNetSuite = $bookingSourceNetSuite;
        }
        return $this;
    }
    /**
     * Get BookingTimeLimit value
     * @return string|null
     */
    public function getBookingTimeLimit()
    {
        return $this->BookingTimeLimit;
    }
    /**
     * Set BookingTimeLimit value
     * @param string $bookingTimeLimit
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setBookingTimeLimit($bookingTimeLimit = null)
    {
        // validation for constraint: string
        if (!is_null($bookingTimeLimit) && !is_string($bookingTimeLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingTimeLimit)), __LINE__);
        }
        $this->BookingTimeLimit = $bookingTimeLimit;
        return $this;
    }
    /**
     * Get CancellationPolicies value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfHotelCancellationPolicyDefinition|null
     */
    public function getCancellationPolicies()
    {
        return isset($this->CancellationPolicies) ? $this->CancellationPolicies : null;
    }
    /**
     * Set CancellationPolicies value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfHotelCancellationPolicyDefinition $cancellationPolicies
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setCancellationPolicies(\ArrayType\ArrayOfHotelCancellationPolicyDefinition $cancellationPolicies = null)
    {
        if (is_null($cancellationPolicies) || (is_array($cancellationPolicies) && empty($cancellationPolicies))) {
            unset($this->CancellationPolicies);
        } else {
            $this->CancellationPolicies = $cancellationPolicies;
        }
        return $this;
    }
    /**
     * Get ClientCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientCode()
    {
        return isset($this->ClientCode) ? $this->ClientCode : null;
    }
    /**
     * Set ClientCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientCode
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setClientCode($clientCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCode) && !is_string($clientCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientCode)), __LINE__);
        }
        if (is_null($clientCode) || (is_array($clientCode) && empty($clientCode))) {
            unset($this->ClientCode);
        } else {
            $this->ClientCode = $clientCode;
        }
        return $this;
    }
    /**
     * Get Contract value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HotelContractDefinition|null
     */
    public function getContract()
    {
        return isset($this->Contract) ? $this->Contract : null;
    }
    /**
     * Set Contract value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\HotelContractDefinition $contract
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setContract(\StructType\HotelContractDefinition $contract = null)
    {
        if (is_null($contract) || (is_array($contract) && empty($contract))) {
            unset($this->Contract);
        } else {
            $this->Contract = $contract;
        }
        return $this;
    }
    /**
     * Get Cost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CostDefinition|null
     */
    public function getCost()
    {
        return isset($this->Cost) ? $this->Cost : null;
    }
    /**
     * Set Cost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CostDefinition $cost
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setCost(\StructType\CostDefinition $cost = null)
    {
        if (is_null($cost) || (is_array($cost) && empty($cost))) {
            unset($this->Cost);
        } else {
            $this->Cost = $cost;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get CustomArgument1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomArgument1()
    {
        return isset($this->CustomArgument1) ? $this->CustomArgument1 : null;
    }
    /**
     * Set CustomArgument1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customArgument1
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setCustomArgument1($customArgument1 = null)
    {
        // validation for constraint: string
        if (!is_null($customArgument1) && !is_string($customArgument1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customArgument1)), __LINE__);
        }
        if (is_null($customArgument1) || (is_array($customArgument1) && empty($customArgument1))) {
            unset($this->CustomArgument1);
        } else {
            $this->CustomArgument1 = $customArgument1;
        }
        return $this;
    }
    /**
     * Get DateFrom value
     * @return string|null
     */
    public function getDateFrom()
    {
        return $this->DateFrom;
    }
    /**
     * Set DateFrom value
     * @param string $dateFrom
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setDateFrom($dateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($dateFrom) && !is_string($dateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateFrom)), __LINE__);
        }
        $this->DateFrom = $dateFrom;
        return $this;
    }
    /**
     * Get DateTo value
     * @return string|null
     */
    public function getDateTo()
    {
        return $this->DateTo;
    }
    /**
     * Set DateTo value
     * @param string $dateTo
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setDateTo($dateTo = null)
    {
        // validation for constraint: string
        if (!is_null($dateTo) && !is_string($dateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateTo)), __LINE__);
        }
        $this->DateTo = $dateTo;
        return $this;
    }
    /**
     * Get Destination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HotelDestinationDefinition|null
     */
    public function getDestination()
    {
        return isset($this->Destination) ? $this->Destination : null;
    }
    /**
     * Set Destination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\HotelDestinationDefinition $destination
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setDestination(\StructType\HotelDestinationDefinition $destination = null)
    {
        if (is_null($destination) || (is_array($destination) && empty($destination))) {
            unset($this->Destination);
        } else {
            $this->Destination = $destination;
        }
        return $this;
    }
    /**
     * Get ExtendedSupplierInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedSupplierInfo()
    {
        return isset($this->ExtendedSupplierInfo) ? $this->ExtendedSupplierInfo : null;
    }
    /**
     * Set ExtendedSupplierInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedSupplierInfo
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setExtendedSupplierInfo($extendedSupplierInfo = null)
    {
        // validation for constraint: string
        if (!is_null($extendedSupplierInfo) && !is_string($extendedSupplierInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extendedSupplierInfo)), __LINE__);
        }
        if (is_null($extendedSupplierInfo) || (is_array($extendedSupplierInfo) && empty($extendedSupplierInfo))) {
            unset($this->ExtendedSupplierInfo);
        } else {
            $this->ExtendedSupplierInfo = $extendedSupplierInfo;
        }
        return $this;
    }
    /**
     * Get FileNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileNumber()
    {
        return isset($this->FileNumber) ? $this->FileNumber : null;
    }
    /**
     * Set FileNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileNumber
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setFileNumber($fileNumber = null)
    {
        // validation for constraint: string
        if (!is_null($fileNumber) && !is_string($fileNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileNumber)), __LINE__);
        }
        if (is_null($fileNumber) || (is_array($fileNumber) && empty($fileNumber))) {
            unset($this->FileNumber);
        } else {
            $this->FileNumber = $fileNumber;
        }
        return $this;
    }
    /**
     * Get HotelCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHotelCode()
    {
        return isset($this->HotelCode) ? $this->HotelCode : null;
    }
    /**
     * Set HotelCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hotelCode
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelCode)), __LINE__);
        }
        if (is_null($hotelCode) || (is_array($hotelCode) && empty($hotelCode))) {
            unset($this->HotelCode);
        } else {
            $this->HotelCode = $hotelCode;
        }
        return $this;
    }
    /**
     * Get HotelId value
     * @return int|null
     */
    public function getHotelId()
    {
        return $this->HotelId;
    }
    /**
     * Set HotelId value
     * @param int $hotelId
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setHotelId($hotelId = null)
    {
        // validation for constraint: int
        if (!is_null($hotelId) && !is_numeric($hotelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hotelId)), __LINE__);
        }
        $this->HotelId = $hotelId;
        return $this;
    }
    /**
     * Get HotelInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HotelInformationDefinition|null
     */
    public function getHotelInformation()
    {
        return isset($this->HotelInformation) ? $this->HotelInformation : null;
    }
    /**
     * Set HotelInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\HotelInformationDefinition $hotelInformation
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setHotelInformation(\StructType\HotelInformationDefinition $hotelInformation = null)
    {
        if (is_null($hotelInformation) || (is_array($hotelInformation) && empty($hotelInformation))) {
            unset($this->HotelInformation);
        } else {
            $this->HotelInformation = $hotelInformation;
        }
        return $this;
    }
    /**
     * Get HotelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHotelName()
    {
        return isset($this->HotelName) ? $this->HotelName : null;
    }
    /**
     * Set HotelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hotelName
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelName)), __LINE__);
        }
        if (is_null($hotelName) || (is_array($hotelName) && empty($hotelName))) {
            unset($this->HotelName);
        } else {
            $this->HotelName = $hotelName;
        }
        return $this;
    }
    /**
     * Get IsCombined value
     * @return bool|null
     */
    public function getIsCombined()
    {
        return $this->IsCombined;
    }
    /**
     * Set IsCombined value
     * @param bool $isCombined
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setIsCombined($isCombined = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCombined) && !is_bool($isCombined)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCombined)), __LINE__);
        }
        $this->IsCombined = $isCombined;
        return $this;
    }
    /**
     * Get MustBePaidBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMustBePaidBy()
    {
        return isset($this->MustBePaidBy) ? $this->MustBePaidBy : null;
    }
    /**
     * Set MustBePaidBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mustBePaidBy
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setMustBePaidBy($mustBePaidBy = null)
    {
        // validation for constraint: string
        if (!is_null($mustBePaidBy) && !is_string($mustBePaidBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mustBePaidBy)), __LINE__);
        }
        if (is_null($mustBePaidBy) || (is_array($mustBePaidBy) && empty($mustBePaidBy))) {
            unset($this->MustBePaidBy);
        } else {
            $this->MustBePaidBy = $mustBePaidBy;
        }
        return $this;
    }
    /**
     * Get PaymentStatus value
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return $this->PaymentStatus;
    }
    /**
     * Set PaymentStatus value
     * @uses \EnumType\ResevationPaymentStatusType::valueIsValid()
     * @uses \EnumType\ResevationPaymentStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentStatus
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setPaymentStatus($paymentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ResevationPaymentStatusType::valueIsValid($paymentStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $paymentStatus, implode(', ', \EnumType\ResevationPaymentStatusType::getValidValues())), __LINE__);
        }
        $this->PaymentStatus = $paymentStatus;
        return $this;
    }
    /**
     * Get PricingType value
     * @return string|null
     */
    public function getPricingType()
    {
        return $this->PricingType;
    }
    /**
     * Set PricingType value
     * @uses \EnumType\HotelRoomBookingPricingType::valueIsValid()
     * @uses \EnumType\HotelRoomBookingPricingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pricingType
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setPricingType($pricingType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HotelRoomBookingPricingType::valueIsValid($pricingType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pricingType, implode(', ', \EnumType\HotelRoomBookingPricingType::getValidValues())), __LINE__);
        }
        $this->PricingType = $pricingType;
        return $this;
    }
    /**
     * Get ProductPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductPriceDefinition|null
     */
    public function getProductPrice()
    {
        return isset($this->ProductPrice) ? $this->ProductPrice : null;
    }
    /**
     * Set ProductPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProductPriceDefinition $productPrice
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setProductPrice(\StructType\ProductPriceDefinition $productPrice = null)
    {
        if (is_null($productPrice) || (is_array($productPrice) && empty($productPrice))) {
            unset($this->ProductPrice);
        } else {
            $this->ProductPrice = $productPrice;
        }
        return $this;
    }
    /**
     * Get ReservationTracer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfHotelReservationTracerDefinition|null
     */
    public function getReservationTracer()
    {
        return isset($this->ReservationTracer) ? $this->ReservationTracer : null;
    }
    /**
     * Set ReservationTracer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfHotelReservationTracerDefinition $reservationTracer
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setReservationTracer(\ArrayType\ArrayOfHotelReservationTracerDefinition $reservationTracer = null)
    {
        if (is_null($reservationTracer) || (is_array($reservationTracer) && empty($reservationTracer))) {
            unset($this->ReservationTracer);
        } else {
            $this->ReservationTracer = $reservationTracer;
        }
        return $this;
    }
    /**
     * Get Rooms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRoomOptionDefinition|null
     */
    public function getRooms()
    {
        return isset($this->Rooms) ? $this->Rooms : null;
    }
    /**
     * Set Rooms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRoomOptionDefinition $rooms
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setRooms(\ArrayType\ArrayOfRoomOptionDefinition $rooms = null)
    {
        if (is_null($rooms) || (is_array($rooms) && empty($rooms))) {
            unset($this->Rooms);
        } else {
            $this->Rooms = $rooms;
        }
        return $this;
    }
    /**
     * Get ServiceProviderReferenceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceProviderReferenceCode()
    {
        return isset($this->ServiceProviderReferenceCode) ? $this->ServiceProviderReferenceCode : null;
    }
    /**
     * Set ServiceProviderReferenceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceProviderReferenceCode
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setServiceProviderReferenceCode($serviceProviderReferenceCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderReferenceCode) && !is_string($serviceProviderReferenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceProviderReferenceCode)), __LINE__);
        }
        if (is_null($serviceProviderReferenceCode) || (is_array($serviceProviderReferenceCode) && empty($serviceProviderReferenceCode))) {
            unset($this->ServiceProviderReferenceCode);
        } else {
            $this->ServiceProviderReferenceCode = $serviceProviderReferenceCode;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\HotelReservationStatusType::valueIsValid()
     * @uses \EnumType\HotelReservationStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HotelReservationStatusType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\HotelReservationStatusType::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusConfirm value
     * @return string|null
     */
    public function getStatusConfirm()
    {
        return $this->StatusConfirm;
    }
    /**
     * Set StatusConfirm value
     * @uses \EnumType\HotelReservationStatusConfirmType::valueIsValid()
     * @uses \EnumType\HotelReservationStatusConfirmType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusConfirm
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setStatusConfirm($statusConfirm = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HotelReservationStatusConfirmType::valueIsValid($statusConfirm)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $statusConfirm, implode(', ', \EnumType\HotelReservationStatusConfirmType::getValidValues())), __LINE__);
        }
        $this->StatusConfirm = $statusConfirm;
        return $this;
    }
    /**
     * Get ThirdPartySupplier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HotelSupplierDefinition|null
     */
    public function getThirdPartySupplier()
    {
        return isset($this->ThirdPartySupplier) ? $this->ThirdPartySupplier : null;
    }
    /**
     * Set ThirdPartySupplier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\HotelSupplierDefinition $thirdPartySupplier
     * @return \StructType\HotelRoomBookingDefinition
     */
    public function setThirdPartySupplier(\StructType\HotelSupplierDefinition $thirdPartySupplier = null)
    {
        if (is_null($thirdPartySupplier) || (is_array($thirdPartySupplier) && empty($thirdPartySupplier))) {
            unset($this->ThirdPartySupplier);
        } else {
            $this->ThirdPartySupplier = $thirdPartySupplier;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelRoomBookingDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
