<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelReservationRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:HotelReservationRequest
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class HotelReservationRequest extends BaseRequest
{
    /**
     * The ExecutionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExecutionType;
    /**
     * The HotelInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HotelInformationDefinition
     */
    public $HotelInformation;
    /**
     * The HotelRoomBooking
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HotelRoomBookingDefinition
     */
    public $HotelRoomBooking;
    /**
     * The ReservationPayment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HotelPaymentDefinition
     */
    public $ReservationPayment;
    /**
     * The ReservationSearch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HotelReservationSearchDefinition
     */
    public $ReservationSearch;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for HotelReservationRequest
     * @uses HotelReservationRequest::setExecutionType()
     * @uses HotelReservationRequest::setHotelInformation()
     * @uses HotelReservationRequest::setHotelRoomBooking()
     * @uses HotelReservationRequest::setReservationPayment()
     * @uses HotelReservationRequest::setReservationSearch()
     * @uses HotelReservationRequest::setStatus()
     * @param string $executionType
     * @param \StructType\HotelInformationDefinition $hotelInformation
     * @param \StructType\HotelRoomBookingDefinition $hotelRoomBooking
     * @param \StructType\HotelPaymentDefinition $reservationPayment
     * @param \StructType\HotelReservationSearchDefinition $reservationSearch
     * @param string $status
     */
    public function __construct($executionType = null, \StructType\HotelInformationDefinition $hotelInformation = null, \StructType\HotelRoomBookingDefinition $hotelRoomBooking = null, \StructType\HotelPaymentDefinition $reservationPayment = null, \StructType\HotelReservationSearchDefinition $reservationSearch = null, $status = null)
    {
        $this
            ->setExecutionType($executionType)
            ->setHotelInformation($hotelInformation)
            ->setHotelRoomBooking($hotelRoomBooking)
            ->setReservationPayment($reservationPayment)
            ->setReservationSearch($reservationSearch)
            ->setStatus($status);
    }
    /**
     * Get ExecutionType value
     * @return string|null
     */
    public function getExecutionType()
    {
        return $this->ExecutionType;
    }
    /**
     * Set ExecutionType value
     * @uses \EnumType\ExecutionType::valueIsValid()
     * @uses \EnumType\ExecutionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $executionType
     * @return \StructType\HotelReservationRequest
     */
    public function setExecutionType($executionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ExecutionType::valueIsValid($executionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $executionType, implode(', ', \EnumType\ExecutionType::getValidValues())), __LINE__);
        }
        $this->ExecutionType = $executionType;
        return $this;
    }
    /**
     * Get HotelInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HotelInformationDefinition|null
     */
    public function getHotelInformation()
    {
        return isset($this->HotelInformation) ? $this->HotelInformation : null;
    }
    /**
     * Set HotelInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\HotelInformationDefinition $hotelInformation
     * @return \StructType\HotelReservationRequest
     */
    public function setHotelInformation(\StructType\HotelInformationDefinition $hotelInformation = null)
    {
        if (is_null($hotelInformation) || (is_array($hotelInformation) && empty($hotelInformation))) {
            unset($this->HotelInformation);
        } else {
            $this->HotelInformation = $hotelInformation;
        }
        return $this;
    }
    /**
     * Get HotelRoomBooking value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HotelRoomBookingDefinition|null
     */
    public function getHotelRoomBooking()
    {
        return isset($this->HotelRoomBooking) ? $this->HotelRoomBooking : null;
    }
    /**
     * Set HotelRoomBooking value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\HotelRoomBookingDefinition $hotelRoomBooking
     * @return \StructType\HotelReservationRequest
     */
    public function setHotelRoomBooking(\StructType\HotelRoomBookingDefinition $hotelRoomBooking = null)
    {
        if (is_null($hotelRoomBooking) || (is_array($hotelRoomBooking) && empty($hotelRoomBooking))) {
            unset($this->HotelRoomBooking);
        } else {
            $this->HotelRoomBooking = $hotelRoomBooking;
        }
        return $this;
    }
    /**
     * Get ReservationPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HotelPaymentDefinition|null
     */
    public function getReservationPayment()
    {
        return isset($this->ReservationPayment) ? $this->ReservationPayment : null;
    }
    /**
     * Set ReservationPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\HotelPaymentDefinition $reservationPayment
     * @return \StructType\HotelReservationRequest
     */
    public function setReservationPayment(\StructType\HotelPaymentDefinition $reservationPayment = null)
    {
        if (is_null($reservationPayment) || (is_array($reservationPayment) && empty($reservationPayment))) {
            unset($this->ReservationPayment);
        } else {
            $this->ReservationPayment = $reservationPayment;
        }
        return $this;
    }
    /**
     * Get ReservationSearch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HotelReservationSearchDefinition|null
     */
    public function getReservationSearch()
    {
        return isset($this->ReservationSearch) ? $this->ReservationSearch : null;
    }
    /**
     * Set ReservationSearch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\HotelReservationSearchDefinition $reservationSearch
     * @return \StructType\HotelReservationRequest
     */
    public function setReservationSearch(\StructType\HotelReservationSearchDefinition $reservationSearch = null)
    {
        if (is_null($reservationSearch) || (is_array($reservationSearch) && empty($reservationSearch))) {
            unset($this->ReservationSearch);
        } else {
            $this->ReservationSearch = $reservationSearch;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\HotelPurchaseStatusType::valueIsValid()
     * @uses \EnumType\HotelPurchaseStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\HotelReservationRequest
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HotelPurchaseStatusType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\HotelPurchaseStatusType::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelReservationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
