<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepositInfoDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DepositInfoDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class DepositInfoDefinition extends AbstractStructBase
{
    /**
     * The ActionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActionType;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The TimeLimitAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TimeLimitAmount;
    /**
     * The TimeLimitReferencePoint
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TimeLimitReferencePoint;
    /**
     * The TimeLimitUnitType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TimeLimitUnitType;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * Constructor method for DepositInfoDefinition
     * @uses DepositInfoDefinition::setActionType()
     * @uses DepositInfoDefinition::setAmount()
     * @uses DepositInfoDefinition::setId()
     * @uses DepositInfoDefinition::setTimeLimitAmount()
     * @uses DepositInfoDefinition::setTimeLimitReferencePoint()
     * @uses DepositInfoDefinition::setTimeLimitUnitType()
     * @uses DepositInfoDefinition::setType()
     * @param string $actionType
     * @param float $amount
     * @param int $id
     * @param int $timeLimitAmount
     * @param string $timeLimitReferencePoint
     * @param string $timeLimitUnitType
     * @param string $type
     */
    public function __construct($actionType = null, $amount = null, $id = null, $timeLimitAmount = null, $timeLimitReferencePoint = null, $timeLimitUnitType = null, $type = null)
    {
        $this
            ->setActionType($actionType)
            ->setAmount($amount)
            ->setId($id)
            ->setTimeLimitAmount($timeLimitAmount)
            ->setTimeLimitReferencePoint($timeLimitReferencePoint)
            ->setTimeLimitUnitType($timeLimitUnitType)
            ->setType($type);
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\DepositInfoDefinition
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $actionType, implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\DepositInfoDefinition
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\DepositInfoDefinition
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get TimeLimitAmount value
     * @return int|null
     */
    public function getTimeLimitAmount()
    {
        return $this->TimeLimitAmount;
    }
    /**
     * Set TimeLimitAmount value
     * @param int $timeLimitAmount
     * @return \StructType\DepositInfoDefinition
     */
    public function setTimeLimitAmount($timeLimitAmount = null)
    {
        // validation for constraint: int
        if (!is_null($timeLimitAmount) && !is_numeric($timeLimitAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($timeLimitAmount)), __LINE__);
        }
        $this->TimeLimitAmount = $timeLimitAmount;
        return $this;
    }
    /**
     * Get TimeLimitReferencePoint value
     * @return string|null
     */
    public function getTimeLimitReferencePoint()
    {
        return $this->TimeLimitReferencePoint;
    }
    /**
     * Set TimeLimitReferencePoint value
     * @uses \EnumType\DepositInfoReferencePointType::valueIsValid()
     * @uses \EnumType\DepositInfoReferencePointType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeLimitReferencePoint
     * @return \StructType\DepositInfoDefinition
     */
    public function setTimeLimitReferencePoint($timeLimitReferencePoint = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DepositInfoReferencePointType::valueIsValid($timeLimitReferencePoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timeLimitReferencePoint, implode(', ', \EnumType\DepositInfoReferencePointType::getValidValues())), __LINE__);
        }
        $this->TimeLimitReferencePoint = $timeLimitReferencePoint;
        return $this;
    }
    /**
     * Get TimeLimitUnitType value
     * @return string|null
     */
    public function getTimeLimitUnitType()
    {
        return $this->TimeLimitUnitType;
    }
    /**
     * Set TimeLimitUnitType value
     * @uses \EnumType\DepositInfoTimeUnitType::valueIsValid()
     * @uses \EnumType\DepositInfoTimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeLimitUnitType
     * @return \StructType\DepositInfoDefinition
     */
    public function setTimeLimitUnitType($timeLimitUnitType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DepositInfoTimeUnitType::valueIsValid($timeLimitUnitType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timeLimitUnitType, implode(', ', \EnumType\DepositInfoTimeUnitType::getValidValues())), __LINE__);
        }
        $this->TimeLimitUnitType = $timeLimitUnitType;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\DepositInfoType::valueIsValid()
     * @uses \EnumType\DepositInfoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\DepositInfoDefinition
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DepositInfoType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\DepositInfoType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DepositInfoDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
