<?php

namespace EnumType;

/**
 * This class stands for HotelReservationStatusType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:HotelReservationStatusType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class HotelReservationStatusType
{
    /**
     * Constant for value 'Available'
     * @return string 'Available'
     */
    const VALUE_AVAILABLE = 'Available';
    /**
     * Constant for value 'Confirmed'
     * @return string 'Confirmed'
     */
    const VALUE_CONFIRMED = 'Confirmed';
    /**
     * Constant for value 'Cancelled'
     * @return string 'Cancelled'
     */
    const VALUE_CANCELLED = 'Cancelled';
    /**
     * Constant for value 'Failed'
     * @return string 'Failed'
     */
    const VALUE_FAILED = 'Failed';
    /**
     * Constant for value 'PendingAvailability'
     * @return string 'PendingAvailability'
     */
    const VALUE_PENDING_AVAILABILITY = 'PendingAvailability';
    /**
     * Constant for value 'Expired'
     * @return string 'Expired'
     */
    const VALUE_EXPIRED = 'Expired';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AVAILABLE
     * @uses self::VALUE_CONFIRMED
     * @uses self::VALUE_CANCELLED
     * @uses self::VALUE_FAILED
     * @uses self::VALUE_PENDING_AVAILABILITY
     * @uses self::VALUE_EXPIRED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AVAILABLE,
            self::VALUE_CONFIRMED,
            self::VALUE_CANCELLED,
            self::VALUE_FAILED,
            self::VALUE_PENDING_AVAILABILITY,
            self::VALUE_EXPIRED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
