<?php

namespace EnumType;

/**
 * This class stands for CreditCardType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CreditCardType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class CreditCardType
{
    /**
     * Constant for value 'Amex'
     * @return string 'Amex'
     */
    const VALUE_AMEX = 'Amex';
    /**
     * Constant for value 'Diners'
     * @return string 'Diners'
     */
    const VALUE_DINERS = 'Diners';
    /**
     * Constant for value 'Mastercard'
     * @return string 'Mastercard'
     */
    const VALUE_MASTERCARD = 'Mastercard';
    /**
     * Constant for value 'Visa'
     * @return string 'Visa'
     */
    const VALUE_VISA = 'Visa';
    /**
     * Constant for value 'Elo'
     * @return string 'Elo'
     */
    const VALUE_ELO = 'Elo';
    /**
     * Constant for value 'Discover'
     * @return string 'Discover'
     */
    const VALUE_DISCOVER = 'Discover';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AMEX
     * @uses self::VALUE_DINERS
     * @uses self::VALUE_MASTERCARD
     * @uses self::VALUE_VISA
     * @uses self::VALUE_ELO
     * @uses self::VALUE_DISCOVER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AMEX,
            self::VALUE_DINERS,
            self::VALUE_MASTERCARD,
            self::VALUE_VISA,
            self::VALUE_ELO,
            self::VALUE_DISCOVER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
