<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservationsHistoryDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ReservationsHistoryDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ReservationsHistoryDefinition extends ClientHistoryDefinition
{
    /**
     * The Reservations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfReservationsDataHistoryDefinition
     */
    public $Reservations;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Status;
    /**
     * Constructor method for ReservationsHistoryDefinition
     * @uses ReservationsHistoryDefinition::setReservations()
     * @uses ReservationsHistoryDefinition::setStatus()
     * @param \ArrayType\ArrayOfReservationsDataHistoryDefinition $reservations
     * @param int $status
     */
    public function __construct(\ArrayType\ArrayOfReservationsDataHistoryDefinition $reservations = null, $status = null)
    {
        $this
            ->setReservations($reservations)
            ->setStatus($status);
    }
    /**
     * Get Reservations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfReservationsDataHistoryDefinition|null
     */
    public function getReservations()
    {
        return isset($this->Reservations) ? $this->Reservations : null;
    }
    /**
     * Set Reservations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfReservationsDataHistoryDefinition $reservations
     * @return \StructType\ReservationsHistoryDefinition
     */
    public function setReservations(\ArrayType\ArrayOfReservationsDataHistoryDefinition $reservations = null)
    {
        if (is_null($reservations) || (is_array($reservations) && empty($reservations))) {
            unset($this->Reservations);
        } else {
            $this->Reservations = $reservations;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \StructType\ReservationsHistoryDefinition
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !is_numeric($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReservationsHistoryDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
