<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservationItemDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ReservationItemDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ReservationItemDefinition extends AbstractStructBase
{
    /**
     * The ActionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActionType;
    /**
     * The Branch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProfileCompanyDefinition
     */
    public $Branch;
    /**
     * The CaseId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CaseId;
    /**
     * The GuaranteeType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GuaranteeType;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The ItinSeqNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ItinSeqNumber;
    /**
     * The LineOfBusiness
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BusinessUnitDefinition
     */
    public $LineOfBusiness;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProfilePersonDefinition
     */
    public $Owner;
    /**
     * The PromoCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PromoCode;
    /**
     * The SalesChannel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SaleChannelDefinition
     */
    public $SalesChannel;
    /**
     * The Supplier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProviderInfoDefinition
     */
    public $Supplier;
    /**
     * The TravelItineraryId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TravelItineraryId;
    /**
     * The Travelers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfReservationItemTravelerDefinition
     */
    public $Travelers;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * Constructor method for ReservationItemDefinition
     * @uses ReservationItemDefinition::setActionType()
     * @uses ReservationItemDefinition::setBranch()
     * @uses ReservationItemDefinition::setCaseId()
     * @uses ReservationItemDefinition::setGuaranteeType()
     * @uses ReservationItemDefinition::setId()
     * @uses ReservationItemDefinition::setItinSeqNumber()
     * @uses ReservationItemDefinition::setLineOfBusiness()
     * @uses ReservationItemDefinition::setOwner()
     * @uses ReservationItemDefinition::setPromoCode()
     * @uses ReservationItemDefinition::setSalesChannel()
     * @uses ReservationItemDefinition::setSupplier()
     * @uses ReservationItemDefinition::setTravelItineraryId()
     * @uses ReservationItemDefinition::setTravelers()
     * @uses ReservationItemDefinition::setType()
     * @param string $actionType
     * @param \StructType\ProfileCompanyDefinition $branch
     * @param int $caseId
     * @param string $guaranteeType
     * @param int $id
     * @param int $itinSeqNumber
     * @param \StructType\BusinessUnitDefinition $lineOfBusiness
     * @param \StructType\ProfilePersonDefinition $owner
     * @param string $promoCode
     * @param \StructType\SaleChannelDefinition $salesChannel
     * @param \StructType\ProviderInfoDefinition $supplier
     * @param int $travelItineraryId
     * @param \ArrayType\ArrayOfReservationItemTravelerDefinition $travelers
     * @param string $type
     */
    public function __construct($actionType = null, \StructType\ProfileCompanyDefinition $branch = null, $caseId = null, $guaranteeType = null, $id = null, $itinSeqNumber = null, \StructType\BusinessUnitDefinition $lineOfBusiness = null, \StructType\ProfilePersonDefinition $owner = null, $promoCode = null, \StructType\SaleChannelDefinition $salesChannel = null, \StructType\ProviderInfoDefinition $supplier = null, $travelItineraryId = null, \ArrayType\ArrayOfReservationItemTravelerDefinition $travelers = null, $type = null)
    {
        $this
            ->setActionType($actionType)
            ->setBranch($branch)
            ->setCaseId($caseId)
            ->setGuaranteeType($guaranteeType)
            ->setId($id)
            ->setItinSeqNumber($itinSeqNumber)
            ->setLineOfBusiness($lineOfBusiness)
            ->setOwner($owner)
            ->setPromoCode($promoCode)
            ->setSalesChannel($salesChannel)
            ->setSupplier($supplier)
            ->setTravelItineraryId($travelItineraryId)
            ->setTravelers($travelers)
            ->setType($type);
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\ReservationItemDefinition
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $actionType, implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProfileCompanyDefinition|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProfileCompanyDefinition $branch
     * @return \StructType\ReservationItemDefinition
     */
    public function setBranch(\StructType\ProfileCompanyDefinition $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get CaseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCaseId()
    {
        return isset($this->CaseId) ? $this->CaseId : null;
    }
    /**
     * Set CaseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $caseId
     * @return \StructType\ReservationItemDefinition
     */
    public function setCaseId($caseId = null)
    {
        // validation for constraint: int
        if (!is_null($caseId) && !is_numeric($caseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($caseId)), __LINE__);
        }
        if (is_null($caseId) || (is_array($caseId) && empty($caseId))) {
            unset($this->CaseId);
        } else {
            $this->CaseId = $caseId;
        }
        return $this;
    }
    /**
     * Get GuaranteeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuaranteeType()
    {
        return isset($this->GuaranteeType) ? $this->GuaranteeType : null;
    }
    /**
     * Set GuaranteeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\GuaranteeType::valueIsValid()
     * @uses \EnumType\GuaranteeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $guaranteeType
     * @return \StructType\ReservationItemDefinition
     */
    public function setGuaranteeType($guaranteeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GuaranteeType::valueIsValid($guaranteeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $guaranteeType, implode(', ', \EnumType\GuaranteeType::getValidValues())), __LINE__);
        }
        if (is_null($guaranteeType) || (is_array($guaranteeType) && empty($guaranteeType))) {
            unset($this->GuaranteeType);
        } else {
            $this->GuaranteeType = $guaranteeType;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\ReservationItemDefinition
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ItinSeqNumber value
     * @return int|null
     */
    public function getItinSeqNumber()
    {
        return $this->ItinSeqNumber;
    }
    /**
     * Set ItinSeqNumber value
     * @param int $itinSeqNumber
     * @return \StructType\ReservationItemDefinition
     */
    public function setItinSeqNumber($itinSeqNumber = null)
    {
        // validation for constraint: int
        if (!is_null($itinSeqNumber) && !is_numeric($itinSeqNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itinSeqNumber)), __LINE__);
        }
        $this->ItinSeqNumber = $itinSeqNumber;
        return $this;
    }
    /**
     * Get LineOfBusiness value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BusinessUnitDefinition|null
     */
    public function getLineOfBusiness()
    {
        return isset($this->LineOfBusiness) ? $this->LineOfBusiness : null;
    }
    /**
     * Set LineOfBusiness value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BusinessUnitDefinition $lineOfBusiness
     * @return \StructType\ReservationItemDefinition
     */
    public function setLineOfBusiness(\StructType\BusinessUnitDefinition $lineOfBusiness = null)
    {
        if (is_null($lineOfBusiness) || (is_array($lineOfBusiness) && empty($lineOfBusiness))) {
            unset($this->LineOfBusiness);
        } else {
            $this->LineOfBusiness = $lineOfBusiness;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProfilePersonDefinition|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProfilePersonDefinition $owner
     * @return \StructType\ReservationItemDefinition
     */
    public function setOwner(\StructType\ProfilePersonDefinition $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get PromoCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromoCode()
    {
        return isset($this->PromoCode) ? $this->PromoCode : null;
    }
    /**
     * Set PromoCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promoCode
     * @return \StructType\ReservationItemDefinition
     */
    public function setPromoCode($promoCode = null)
    {
        // validation for constraint: string
        if (!is_null($promoCode) && !is_string($promoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($promoCode)), __LINE__);
        }
        if (is_null($promoCode) || (is_array($promoCode) && empty($promoCode))) {
            unset($this->PromoCode);
        } else {
            $this->PromoCode = $promoCode;
        }
        return $this;
    }
    /**
     * Get SalesChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SaleChannelDefinition|null
     */
    public function getSalesChannel()
    {
        return isset($this->SalesChannel) ? $this->SalesChannel : null;
    }
    /**
     * Set SalesChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SaleChannelDefinition $salesChannel
     * @return \StructType\ReservationItemDefinition
     */
    public function setSalesChannel(\StructType\SaleChannelDefinition $salesChannel = null)
    {
        if (is_null($salesChannel) || (is_array($salesChannel) && empty($salesChannel))) {
            unset($this->SalesChannel);
        } else {
            $this->SalesChannel = $salesChannel;
        }
        return $this;
    }
    /**
     * Get Supplier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProviderInfoDefinition|null
     */
    public function getSupplier()
    {
        return isset($this->Supplier) ? $this->Supplier : null;
    }
    /**
     * Set Supplier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProviderInfoDefinition $supplier
     * @return \StructType\ReservationItemDefinition
     */
    public function setSupplier(\StructType\ProviderInfoDefinition $supplier = null)
    {
        if (is_null($supplier) || (is_array($supplier) && empty($supplier))) {
            unset($this->Supplier);
        } else {
            $this->Supplier = $supplier;
        }
        return $this;
    }
    /**
     * Get TravelItineraryId value
     * @return int|null
     */
    public function getTravelItineraryId()
    {
        return $this->TravelItineraryId;
    }
    /**
     * Set TravelItineraryId value
     * @param int $travelItineraryId
     * @return \StructType\ReservationItemDefinition
     */
    public function setTravelItineraryId($travelItineraryId = null)
    {
        // validation for constraint: int
        if (!is_null($travelItineraryId) && !is_numeric($travelItineraryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($travelItineraryId)), __LINE__);
        }
        $this->TravelItineraryId = $travelItineraryId;
        return $this;
    }
    /**
     * Get Travelers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfReservationItemTravelerDefinition|null
     */
    public function getTravelers()
    {
        return isset($this->Travelers) ? $this->Travelers : null;
    }
    /**
     * Set Travelers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfReservationItemTravelerDefinition $travelers
     * @return \StructType\ReservationItemDefinition
     */
    public function setTravelers(\ArrayType\ArrayOfReservationItemTravelerDefinition $travelers = null)
    {
        if (is_null($travelers) || (is_array($travelers) && empty($travelers))) {
            unset($this->Travelers);
        } else {
            $this->Travelers = $travelers;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\ReservationItemType::valueIsValid()
     * @uses \EnumType\ReservationItemType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\ReservationItemDefinition
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReservationItemType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\ReservationItemType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReservationItemDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
