<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QuoteHistoryDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:QuoteHistoryDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class QuoteHistoryDefinition extends ClientHistoryDefinition
{
    /**
     * The AirItems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AirItems;
    /**
     * The ExtraItems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraItems;
    /**
     * The HotelItems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HotelItems;
    /**
     * The PackageItems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PackageItems;
    /**
     * The QuoteUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QuoteUrl;
    /**
     * The TravelItineraryId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TravelItineraryId;
    /**
     * Constructor method for QuoteHistoryDefinition
     * @uses QuoteHistoryDefinition::setAirItems()
     * @uses QuoteHistoryDefinition::setExtraItems()
     * @uses QuoteHistoryDefinition::setHotelItems()
     * @uses QuoteHistoryDefinition::setPackageItems()
     * @uses QuoteHistoryDefinition::setQuoteUrl()
     * @uses QuoteHistoryDefinition::setTravelItineraryId()
     * @param string $airItems
     * @param string $extraItems
     * @param string $hotelItems
     * @param string $packageItems
     * @param string $quoteUrl
     * @param string $travelItineraryId
     */
    public function __construct($airItems = null, $extraItems = null, $hotelItems = null, $packageItems = null, $quoteUrl = null, $travelItineraryId = null)
    {
        $this
            ->setAirItems($airItems)
            ->setExtraItems($extraItems)
            ->setHotelItems($hotelItems)
            ->setPackageItems($packageItems)
            ->setQuoteUrl($quoteUrl)
            ->setTravelItineraryId($travelItineraryId);
    }
    /**
     * Get AirItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAirItems()
    {
        return isset($this->AirItems) ? $this->AirItems : null;
    }
    /**
     * Set AirItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $airItems
     * @return \StructType\QuoteHistoryDefinition
     */
    public function setAirItems($airItems = null)
    {
        // validation for constraint: string
        if (!is_null($airItems) && !is_string($airItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airItems)), __LINE__);
        }
        if (is_null($airItems) || (is_array($airItems) && empty($airItems))) {
            unset($this->AirItems);
        } else {
            $this->AirItems = $airItems;
        }
        return $this;
    }
    /**
     * Get ExtraItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraItems()
    {
        return isset($this->ExtraItems) ? $this->ExtraItems : null;
    }
    /**
     * Set ExtraItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraItems
     * @return \StructType\QuoteHistoryDefinition
     */
    public function setExtraItems($extraItems = null)
    {
        // validation for constraint: string
        if (!is_null($extraItems) && !is_string($extraItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extraItems)), __LINE__);
        }
        if (is_null($extraItems) || (is_array($extraItems) && empty($extraItems))) {
            unset($this->ExtraItems);
        } else {
            $this->ExtraItems = $extraItems;
        }
        return $this;
    }
    /**
     * Get HotelItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHotelItems()
    {
        return isset($this->HotelItems) ? $this->HotelItems : null;
    }
    /**
     * Set HotelItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hotelItems
     * @return \StructType\QuoteHistoryDefinition
     */
    public function setHotelItems($hotelItems = null)
    {
        // validation for constraint: string
        if (!is_null($hotelItems) && !is_string($hotelItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelItems)), __LINE__);
        }
        if (is_null($hotelItems) || (is_array($hotelItems) && empty($hotelItems))) {
            unset($this->HotelItems);
        } else {
            $this->HotelItems = $hotelItems;
        }
        return $this;
    }
    /**
     * Get PackageItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPackageItems()
    {
        return isset($this->PackageItems) ? $this->PackageItems : null;
    }
    /**
     * Set PackageItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packageItems
     * @return \StructType\QuoteHistoryDefinition
     */
    public function setPackageItems($packageItems = null)
    {
        // validation for constraint: string
        if (!is_null($packageItems) && !is_string($packageItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packageItems)), __LINE__);
        }
        if (is_null($packageItems) || (is_array($packageItems) && empty($packageItems))) {
            unset($this->PackageItems);
        } else {
            $this->PackageItems = $packageItems;
        }
        return $this;
    }
    /**
     * Get QuoteUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQuoteUrl()
    {
        return isset($this->QuoteUrl) ? $this->QuoteUrl : null;
    }
    /**
     * Set QuoteUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $quoteUrl
     * @return \StructType\QuoteHistoryDefinition
     */
    public function setQuoteUrl($quoteUrl = null)
    {
        // validation for constraint: string
        if (!is_null($quoteUrl) && !is_string($quoteUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quoteUrl)), __LINE__);
        }
        if (is_null($quoteUrl) || (is_array($quoteUrl) && empty($quoteUrl))) {
            unset($this->QuoteUrl);
        } else {
            $this->QuoteUrl = $quoteUrl;
        }
        return $this;
    }
    /**
     * Get TravelItineraryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTravelItineraryId()
    {
        return isset($this->TravelItineraryId) ? $this->TravelItineraryId : null;
    }
    /**
     * Set TravelItineraryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $travelItineraryId
     * @return \StructType\QuoteHistoryDefinition
     */
    public function setTravelItineraryId($travelItineraryId = null)
    {
        // validation for constraint: string
        if (!is_null($travelItineraryId) && !is_string($travelItineraryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelItineraryId)), __LINE__);
        }
        if (is_null($travelItineraryId) || (is_array($travelItineraryId) && empty($travelItineraryId))) {
            unset($this->TravelItineraryId);
        } else {
            $this->TravelItineraryId = $travelItineraryId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QuoteHistoryDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
