<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfilePhoneDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProfilePhoneDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ProfilePhoneDefinition extends AbstractStructBase
{
    /**
     * The ActionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActionType;
    /**
     * The CityCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CityCode;
    /**
     * The ContactType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ContactType;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CountryCode;
    /**
     * The Extension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Extension;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Number;
    /**
     * The PhoneId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PhoneId;
    /**
     * The PhoneType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PhoneType;
    /**
     * The ProfileId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProfileId;
    /**
     * The SmsNotifications
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SmsNotifications;
    /**
     * Constructor method for ProfilePhoneDefinition
     * @uses ProfilePhoneDefinition::setActionType()
     * @uses ProfilePhoneDefinition::setCityCode()
     * @uses ProfilePhoneDefinition::setContactType()
     * @uses ProfilePhoneDefinition::setCountryCode()
     * @uses ProfilePhoneDefinition::setExtension()
     * @uses ProfilePhoneDefinition::setNumber()
     * @uses ProfilePhoneDefinition::setPhoneId()
     * @uses ProfilePhoneDefinition::setPhoneType()
     * @uses ProfilePhoneDefinition::setProfileId()
     * @uses ProfilePhoneDefinition::setSmsNotifications()
     * @param string $actionType
     * @param string $cityCode
     * @param string $contactType
     * @param string $countryCode
     * @param string $extension
     * @param string $number
     * @param int $phoneId
     * @param string $phoneType
     * @param int $profileId
     * @param bool $smsNotifications
     */
    public function __construct($actionType = null, $cityCode = null, $contactType = null, $countryCode = null, $extension = null, $number = null, $phoneId = null, $phoneType = null, $profileId = null, $smsNotifications = null)
    {
        $this
            ->setActionType($actionType)
            ->setCityCode($cityCode)
            ->setContactType($contactType)
            ->setCountryCode($countryCode)
            ->setExtension($extension)
            ->setNumber($number)
            ->setPhoneId($phoneId)
            ->setPhoneType($phoneType)
            ->setProfileId($profileId)
            ->setSmsNotifications($smsNotifications);
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\ProfilePhoneDefinition
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $actionType, implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get CityCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCityCode()
    {
        return isset($this->CityCode) ? $this->CityCode : null;
    }
    /**
     * Set CityCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cityCode
     * @return \StructType\ProfilePhoneDefinition
     */
    public function setCityCode($cityCode = null)
    {
        // validation for constraint: string
        if (!is_null($cityCode) && !is_string($cityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cityCode)), __LINE__);
        }
        if (is_null($cityCode) || (is_array($cityCode) && empty($cityCode))) {
            unset($this->CityCode);
        } else {
            $this->CityCode = $cityCode;
        }
        return $this;
    }
    /**
     * Get ContactType value
     * @return string|null
     */
    public function getContactType()
    {
        return $this->ContactType;
    }
    /**
     * Set ContactType value
     * @uses \EnumType\ProfileContactType::valueIsValid()
     * @uses \EnumType\ProfileContactType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contactType
     * @return \StructType\ProfilePhoneDefinition
     */
    public function setContactType($contactType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProfileContactType::valueIsValid($contactType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $contactType, implode(', ', \EnumType\ProfileContactType::getValidValues())), __LINE__);
        }
        $this->ContactType = $contactType;
        return $this;
    }
    /**
     * Get CountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryCode()
    {
        return isset($this->CountryCode) ? $this->CountryCode : null;
    }
    /**
     * Set CountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryCode
     * @return \StructType\ProfilePhoneDefinition
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        if (is_null($countryCode) || (is_array($countryCode) && empty($countryCode))) {
            unset($this->CountryCode);
        } else {
            $this->CountryCode = $countryCode;
        }
        return $this;
    }
    /**
     * Get Extension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtension()
    {
        return isset($this->Extension) ? $this->Extension : null;
    }
    /**
     * Set Extension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extension
     * @return \StructType\ProfilePhoneDefinition
     */
    public function setExtension($extension = null)
    {
        // validation for constraint: string
        if (!is_null($extension) && !is_string($extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extension)), __LINE__);
        }
        if (is_null($extension) || (is_array($extension) && empty($extension))) {
            unset($this->Extension);
        } else {
            $this->Extension = $extension;
        }
        return $this;
    }
    /**
     * Get Number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumber()
    {
        return isset($this->Number) ? $this->Number : null;
    }
    /**
     * Set Number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $number
     * @return \StructType\ProfilePhoneDefinition
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        if (is_null($number) || (is_array($number) && empty($number))) {
            unset($this->Number);
        } else {
            $this->Number = $number;
        }
        return $this;
    }
    /**
     * Get PhoneId value
     * @return int|null
     */
    public function getPhoneId()
    {
        return $this->PhoneId;
    }
    /**
     * Set PhoneId value
     * @param int $phoneId
     * @return \StructType\ProfilePhoneDefinition
     */
    public function setPhoneId($phoneId = null)
    {
        // validation for constraint: int
        if (!is_null($phoneId) && !is_numeric($phoneId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($phoneId)), __LINE__);
        }
        $this->PhoneId = $phoneId;
        return $this;
    }
    /**
     * Get PhoneType value
     * @return string|null
     */
    public function getPhoneType()
    {
        return $this->PhoneType;
    }
    /**
     * Set PhoneType value
     * @uses \EnumType\ProfilePhoneType::valueIsValid()
     * @uses \EnumType\ProfilePhoneType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneType
     * @return \StructType\ProfilePhoneDefinition
     */
    public function setPhoneType($phoneType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProfilePhoneType::valueIsValid($phoneType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $phoneType, implode(', ', \EnumType\ProfilePhoneType::getValidValues())), __LINE__);
        }
        $this->PhoneType = $phoneType;
        return $this;
    }
    /**
     * Get ProfileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->ProfileId;
    }
    /**
     * Set ProfileId value
     * @param int $profileId
     * @return \StructType\ProfilePhoneDefinition
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !is_numeric($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileId)), __LINE__);
        }
        $this->ProfileId = $profileId;
        return $this;
    }
    /**
     * Get SmsNotifications value
     * @return bool|null
     */
    public function getSmsNotifications()
    {
        return $this->SmsNotifications;
    }
    /**
     * Set SmsNotifications value
     * @param bool $smsNotifications
     * @return \StructType\ProfilePhoneDefinition
     */
    public function setSmsNotifications($smsNotifications = null)
    {
        // validation for constraint: boolean
        if (!is_null($smsNotifications) && !is_bool($smsNotifications)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($smsNotifications)), __LINE__);
        }
        $this->SmsNotifications = $smsNotifications;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProfilePhoneDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
