<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfileHierarchyDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProfileHierarchyDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ProfileHierarchyDefinition extends AbstractStructBase
{
    /**
     * The ActionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActionType;
    /**
     * The HierarchyType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HierarchyType;
    /**
     * The ParentProfileId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ParentProfileId;
    /**
     * The ProfileHierarchyId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProfileHierarchyId;
    /**
     * Constructor method for ProfileHierarchyDefinition
     * @uses ProfileHierarchyDefinition::setActionType()
     * @uses ProfileHierarchyDefinition::setHierarchyType()
     * @uses ProfileHierarchyDefinition::setParentProfileId()
     * @uses ProfileHierarchyDefinition::setProfileHierarchyId()
     * @param string $actionType
     * @param string $hierarchyType
     * @param int $parentProfileId
     * @param int $profileHierarchyId
     */
    public function __construct($actionType = null, $hierarchyType = null, $parentProfileId = null, $profileHierarchyId = null)
    {
        $this
            ->setActionType($actionType)
            ->setHierarchyType($hierarchyType)
            ->setParentProfileId($parentProfileId)
            ->setProfileHierarchyId($profileHierarchyId);
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\ProfileHierarchyDefinition
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $actionType, implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get HierarchyType value
     * @return string|null
     */
    public function getHierarchyType()
    {
        return $this->HierarchyType;
    }
    /**
     * Set HierarchyType value
     * @uses \EnumType\ProfileHierarchyType::valueIsValid()
     * @uses \EnumType\ProfileHierarchyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hierarchyType
     * @return \StructType\ProfileHierarchyDefinition
     */
    public function setHierarchyType($hierarchyType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProfileHierarchyType::valueIsValid($hierarchyType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $hierarchyType, implode(', ', \EnumType\ProfileHierarchyType::getValidValues())), __LINE__);
        }
        $this->HierarchyType = $hierarchyType;
        return $this;
    }
    /**
     * Get ParentProfileId value
     * @return int|null
     */
    public function getParentProfileId()
    {
        return $this->ParentProfileId;
    }
    /**
     * Set ParentProfileId value
     * @param int $parentProfileId
     * @return \StructType\ProfileHierarchyDefinition
     */
    public function setParentProfileId($parentProfileId = null)
    {
        // validation for constraint: int
        if (!is_null($parentProfileId) && !is_numeric($parentProfileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($parentProfileId)), __LINE__);
        }
        $this->ParentProfileId = $parentProfileId;
        return $this;
    }
    /**
     * Get ProfileHierarchyId value
     * @return int|null
     */
    public function getProfileHierarchyId()
    {
        return $this->ProfileHierarchyId;
    }
    /**
     * Set ProfileHierarchyId value
     * @param int $profileHierarchyId
     * @return \StructType\ProfileHierarchyDefinition
     */
    public function setProfileHierarchyId($profileHierarchyId = null)
    {
        // validation for constraint: int
        if (!is_null($profileHierarchyId) && !is_numeric($profileHierarchyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileHierarchyId)), __LINE__);
        }
        $this->ProfileHierarchyId = $profileHierarchyId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProfileHierarchyDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
