<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfileCardTypeDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProfileCardTypeDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ProfileCardTypeDefinition extends AbstractStructBase
{
    /**
     * The CardTypeId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CardTypeId;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The Desc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Desc;
    /**
     * The IsDebit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsDebit;
    /**
     * Constructor method for ProfileCardTypeDefinition
     * @uses ProfileCardTypeDefinition::setCardTypeId()
     * @uses ProfileCardTypeDefinition::setCode()
     * @uses ProfileCardTypeDefinition::setDesc()
     * @uses ProfileCardTypeDefinition::setIsDebit()
     * @param int $cardTypeId
     * @param string $code
     * @param string $desc
     * @param bool $isDebit
     */
    public function __construct($cardTypeId = null, $code = null, $desc = null, $isDebit = null)
    {
        $this
            ->setCardTypeId($cardTypeId)
            ->setCode($code)
            ->setDesc($desc)
            ->setIsDebit($isDebit);
    }
    /**
     * Get CardTypeId value
     * @return int|null
     */
    public function getCardTypeId()
    {
        return $this->CardTypeId;
    }
    /**
     * Set CardTypeId value
     * @param int $cardTypeId
     * @return \StructType\ProfileCardTypeDefinition
     */
    public function setCardTypeId($cardTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($cardTypeId) && !is_numeric($cardTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cardTypeId)), __LINE__);
        }
        $this->CardTypeId = $cardTypeId;
        return $this;
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \StructType\ProfileCardTypeDefinition
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get Desc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDesc()
    {
        return isset($this->Desc) ? $this->Desc : null;
    }
    /**
     * Set Desc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $desc
     * @return \StructType\ProfileCardTypeDefinition
     */
    public function setDesc($desc = null)
    {
        // validation for constraint: string
        if (!is_null($desc) && !is_string($desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($desc)), __LINE__);
        }
        if (is_null($desc) || (is_array($desc) && empty($desc))) {
            unset($this->Desc);
        } else {
            $this->Desc = $desc;
        }
        return $this;
    }
    /**
     * Get IsDebit value
     * @return bool|null
     */
    public function getIsDebit()
    {
        return $this->IsDebit;
    }
    /**
     * Set IsDebit value
     * @param bool $isDebit
     * @return \StructType\ProfileCardTypeDefinition
     */
    public function setIsDebit($isDebit = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDebit) && !is_bool($isDebit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDebit)), __LINE__);
        }
        $this->IsDebit = $isDebit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProfileCardTypeDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
