<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfileBankDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProfileBankDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ProfileBankDefinition extends AbstractStructBase
{
    /**
     * The BankId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BankId;
    /**
     * The Desc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Desc;
    /**
     * Constructor method for ProfileBankDefinition
     * @uses ProfileBankDefinition::setBankId()
     * @uses ProfileBankDefinition::setDesc()
     * @param int $bankId
     * @param string $desc
     */
    public function __construct($bankId = null, $desc = null)
    {
        $this
            ->setBankId($bankId)
            ->setDesc($desc);
    }
    /**
     * Get BankId value
     * @return int|null
     */
    public function getBankId()
    {
        return $this->BankId;
    }
    /**
     * Set BankId value
     * @param int $bankId
     * @return \StructType\ProfileBankDefinition
     */
    public function setBankId($bankId = null)
    {
        // validation for constraint: int
        if (!is_null($bankId) && !is_numeric($bankId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bankId)), __LINE__);
        }
        $this->BankId = $bankId;
        return $this;
    }
    /**
     * Get Desc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDesc()
    {
        return isset($this->Desc) ? $this->Desc : null;
    }
    /**
     * Set Desc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $desc
     * @return \StructType\ProfileBankDefinition
     */
    public function setDesc($desc = null)
    {
        // validation for constraint: string
        if (!is_null($desc) && !is_string($desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($desc)), __LINE__);
        }
        if (is_null($desc) || (is_array($desc) && empty($desc))) {
            unset($this->Desc);
        } else {
            $this->Desc = $desc;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProfileBankDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
