<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelInformationDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:HotelInformationDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class HotelInformationDefinition extends AbstractStructBase
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Category;
    /**
     * The CategoryCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CategoryCode;
    /**
     * The CategoryDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CategoryDescription;
    /**
     * The Chain
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DataDefinition
     */
    public $Chain;
    /**
     * The ChildPolicy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ChildPolicyDefinition
     */
    public $ChildPolicy;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HotelContactDefinition
     */
    public $Contact;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Descriptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfHotelDescriptionDefinition
     */
    public $Descriptions;
    /**
     * The Destination
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HotelDestinationDefinition
     */
    public $Destination;
    /**
     * The EntityChangesHistory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfEntityChangesHistoryDefinition
     */
    public $EntityChangesHistory;
    /**
     * The Facilities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfHotelFacilityDefinition
     */
    public $Facilities;
    /**
     * The HotelInfoRoomTypes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfHotelInfoRoomTypeDefinition
     */
    public $HotelInfoRoomTypes;
    /**
     * The HotelProvider
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HotelProvider;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Images
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfImageItemDefinition
     */
    public $Images;
    /**
     * The IsForAutoComplete
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsForAutoComplete;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PositionDefinition
     */
    public $Position;
    /**
     * The RoomTypes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRoomTypeDefinition
     */
    public $RoomTypes;
    /**
     * The SupplierId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SupplierId;
    /**
     * The SupplierName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SupplierName;
    /**
     * The UnifiedHotelCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UnifiedHotelCode;
    /**
     * Constructor method for HotelInformationDefinition
     * @uses HotelInformationDefinition::setActive()
     * @uses HotelInformationDefinition::setCategory()
     * @uses HotelInformationDefinition::setCategoryCode()
     * @uses HotelInformationDefinition::setCategoryDescription()
     * @uses HotelInformationDefinition::setChain()
     * @uses HotelInformationDefinition::setChildPolicy()
     * @uses HotelInformationDefinition::setCode()
     * @uses HotelInformationDefinition::setContact()
     * @uses HotelInformationDefinition::setCurrencyCode()
     * @uses HotelInformationDefinition::setDescriptions()
     * @uses HotelInformationDefinition::setDestination()
     * @uses HotelInformationDefinition::setEntityChangesHistory()
     * @uses HotelInformationDefinition::setFacilities()
     * @uses HotelInformationDefinition::setHotelInfoRoomTypes()
     * @uses HotelInformationDefinition::setHotelProvider()
     * @uses HotelInformationDefinition::setId()
     * @uses HotelInformationDefinition::setImages()
     * @uses HotelInformationDefinition::setIsForAutoComplete()
     * @uses HotelInformationDefinition::setName()
     * @uses HotelInformationDefinition::setPosition()
     * @uses HotelInformationDefinition::setRoomTypes()
     * @uses HotelInformationDefinition::setSupplierId()
     * @uses HotelInformationDefinition::setSupplierName()
     * @uses HotelInformationDefinition::setUnifiedHotelCode()
     * @param bool $active
     * @param string $category
     * @param string $categoryCode
     * @param string $categoryDescription
     * @param \StructType\DataDefinition $chain
     * @param \StructType\ChildPolicyDefinition $childPolicy
     * @param string $code
     * @param \StructType\HotelContactDefinition $contact
     * @param string $currencyCode
     * @param \ArrayType\ArrayOfHotelDescriptionDefinition $descriptions
     * @param \StructType\HotelDestinationDefinition $destination
     * @param \ArrayType\ArrayOfEntityChangesHistoryDefinition $entityChangesHistory
     * @param \ArrayType\ArrayOfHotelFacilityDefinition $facilities
     * @param \ArrayType\ArrayOfHotelInfoRoomTypeDefinition $hotelInfoRoomTypes
     * @param string $hotelProvider
     * @param int $id
     * @param \ArrayType\ArrayOfImageItemDefinition $images
     * @param bool $isForAutoComplete
     * @param string $name
     * @param \StructType\PositionDefinition $position
     * @param \ArrayType\ArrayOfRoomTypeDefinition $roomTypes
     * @param int $supplierId
     * @param string $supplierName
     * @param string $unifiedHotelCode
     */
    public function __construct($active = null, $category = null, $categoryCode = null, $categoryDescription = null, \StructType\DataDefinition $chain = null, \StructType\ChildPolicyDefinition $childPolicy = null, $code = null, \StructType\HotelContactDefinition $contact = null, $currencyCode = null, \ArrayType\ArrayOfHotelDescriptionDefinition $descriptions = null, \StructType\HotelDestinationDefinition $destination = null, \ArrayType\ArrayOfEntityChangesHistoryDefinition $entityChangesHistory = null, \ArrayType\ArrayOfHotelFacilityDefinition $facilities = null, \ArrayType\ArrayOfHotelInfoRoomTypeDefinition $hotelInfoRoomTypes = null, $hotelProvider = null, $id = null, \ArrayType\ArrayOfImageItemDefinition $images = null, $isForAutoComplete = null, $name = null, \StructType\PositionDefinition $position = null, \ArrayType\ArrayOfRoomTypeDefinition $roomTypes = null, $supplierId = null, $supplierName = null, $unifiedHotelCode = null)
    {
        $this
            ->setActive($active)
            ->setCategory($category)
            ->setCategoryCode($categoryCode)
            ->setCategoryDescription($categoryDescription)
            ->setChain($chain)
            ->setChildPolicy($childPolicy)
            ->setCode($code)
            ->setContact($contact)
            ->setCurrencyCode($currencyCode)
            ->setDescriptions($descriptions)
            ->setDestination($destination)
            ->setEntityChangesHistory($entityChangesHistory)
            ->setFacilities($facilities)
            ->setHotelInfoRoomTypes($hotelInfoRoomTypes)
            ->setHotelProvider($hotelProvider)
            ->setId($id)
            ->setImages($images)
            ->setIsForAutoComplete($isForAutoComplete)
            ->setName($name)
            ->setPosition($position)
            ->setRoomTypes($roomTypes)
            ->setSupplierId($supplierId)
            ->setSupplierName($supplierName)
            ->setUnifiedHotelCode($unifiedHotelCode);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\HotelInformationDefinition
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @uses \EnumType\CategoryType::valueIsValid()
     * @uses \EnumType\CategoryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $category
     * @return \StructType\HotelInformationDefinition
     */
    public function setCategory($category = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CategoryType::valueIsValid($category)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $category, implode(', ', \EnumType\CategoryType::getValidValues())), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get CategoryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryCode()
    {
        return isset($this->CategoryCode) ? $this->CategoryCode : null;
    }
    /**
     * Set CategoryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryCode
     * @return \StructType\HotelInformationDefinition
     */
    public function setCategoryCode($categoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($categoryCode) && !is_string($categoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categoryCode)), __LINE__);
        }
        if (is_null($categoryCode) || (is_array($categoryCode) && empty($categoryCode))) {
            unset($this->CategoryCode);
        } else {
            $this->CategoryCode = $categoryCode;
        }
        return $this;
    }
    /**
     * Get CategoryDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryDescription()
    {
        return isset($this->CategoryDescription) ? $this->CategoryDescription : null;
    }
    /**
     * Set CategoryDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryDescription
     * @return \StructType\HotelInformationDefinition
     */
    public function setCategoryDescription($categoryDescription = null)
    {
        // validation for constraint: string
        if (!is_null($categoryDescription) && !is_string($categoryDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categoryDescription)), __LINE__);
        }
        if (is_null($categoryDescription) || (is_array($categoryDescription) && empty($categoryDescription))) {
            unset($this->CategoryDescription);
        } else {
            $this->CategoryDescription = $categoryDescription;
        }
        return $this;
    }
    /**
     * Get Chain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DataDefinition|null
     */
    public function getChain()
    {
        return isset($this->Chain) ? $this->Chain : null;
    }
    /**
     * Set Chain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DataDefinition $chain
     * @return \StructType\HotelInformationDefinition
     */
    public function setChain(\StructType\DataDefinition $chain = null)
    {
        if (is_null($chain) || (is_array($chain) && empty($chain))) {
            unset($this->Chain);
        } else {
            $this->Chain = $chain;
        }
        return $this;
    }
    /**
     * Get ChildPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ChildPolicyDefinition|null
     */
    public function getChildPolicy()
    {
        return isset($this->ChildPolicy) ? $this->ChildPolicy : null;
    }
    /**
     * Set ChildPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ChildPolicyDefinition $childPolicy
     * @return \StructType\HotelInformationDefinition
     */
    public function setChildPolicy(\StructType\ChildPolicyDefinition $childPolicy = null)
    {
        if (is_null($childPolicy) || (is_array($childPolicy) && empty($childPolicy))) {
            unset($this->ChildPolicy);
        } else {
            $this->ChildPolicy = $childPolicy;
        }
        return $this;
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \StructType\HotelInformationDefinition
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get Contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HotelContactDefinition|null
     */
    public function getContact()
    {
        return isset($this->Contact) ? $this->Contact : null;
    }
    /**
     * Set Contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\HotelContactDefinition $contact
     * @return \StructType\HotelInformationDefinition
     */
    public function setContact(\StructType\HotelContactDefinition $contact = null)
    {
        if (is_null($contact) || (is_array($contact) && empty($contact))) {
            unset($this->Contact);
        } else {
            $this->Contact = $contact;
        }
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\HotelInformationDefinition
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get Descriptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfHotelDescriptionDefinition|null
     */
    public function getDescriptions()
    {
        return isset($this->Descriptions) ? $this->Descriptions : null;
    }
    /**
     * Set Descriptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfHotelDescriptionDefinition $descriptions
     * @return \StructType\HotelInformationDefinition
     */
    public function setDescriptions(\ArrayType\ArrayOfHotelDescriptionDefinition $descriptions = null)
    {
        if (is_null($descriptions) || (is_array($descriptions) && empty($descriptions))) {
            unset($this->Descriptions);
        } else {
            $this->Descriptions = $descriptions;
        }
        return $this;
    }
    /**
     * Get Destination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HotelDestinationDefinition|null
     */
    public function getDestination()
    {
        return isset($this->Destination) ? $this->Destination : null;
    }
    /**
     * Set Destination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\HotelDestinationDefinition $destination
     * @return \StructType\HotelInformationDefinition
     */
    public function setDestination(\StructType\HotelDestinationDefinition $destination = null)
    {
        if (is_null($destination) || (is_array($destination) && empty($destination))) {
            unset($this->Destination);
        } else {
            $this->Destination = $destination;
        }
        return $this;
    }
    /**
     * Get EntityChangesHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfEntityChangesHistoryDefinition|null
     */
    public function getEntityChangesHistory()
    {
        return isset($this->EntityChangesHistory) ? $this->EntityChangesHistory : null;
    }
    /**
     * Set EntityChangesHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfEntityChangesHistoryDefinition $entityChangesHistory
     * @return \StructType\HotelInformationDefinition
     */
    public function setEntityChangesHistory(\ArrayType\ArrayOfEntityChangesHistoryDefinition $entityChangesHistory = null)
    {
        if (is_null($entityChangesHistory) || (is_array($entityChangesHistory) && empty($entityChangesHistory))) {
            unset($this->EntityChangesHistory);
        } else {
            $this->EntityChangesHistory = $entityChangesHistory;
        }
        return $this;
    }
    /**
     * Get Facilities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfHotelFacilityDefinition|null
     */
    public function getFacilities()
    {
        return isset($this->Facilities) ? $this->Facilities : null;
    }
    /**
     * Set Facilities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfHotelFacilityDefinition $facilities
     * @return \StructType\HotelInformationDefinition
     */
    public function setFacilities(\ArrayType\ArrayOfHotelFacilityDefinition $facilities = null)
    {
        if (is_null($facilities) || (is_array($facilities) && empty($facilities))) {
            unset($this->Facilities);
        } else {
            $this->Facilities = $facilities;
        }
        return $this;
    }
    /**
     * Get HotelInfoRoomTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfHotelInfoRoomTypeDefinition|null
     */
    public function getHotelInfoRoomTypes()
    {
        return isset($this->HotelInfoRoomTypes) ? $this->HotelInfoRoomTypes : null;
    }
    /**
     * Set HotelInfoRoomTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfHotelInfoRoomTypeDefinition $hotelInfoRoomTypes
     * @return \StructType\HotelInformationDefinition
     */
    public function setHotelInfoRoomTypes(\ArrayType\ArrayOfHotelInfoRoomTypeDefinition $hotelInfoRoomTypes = null)
    {
        if (is_null($hotelInfoRoomTypes) || (is_array($hotelInfoRoomTypes) && empty($hotelInfoRoomTypes))) {
            unset($this->HotelInfoRoomTypes);
        } else {
            $this->HotelInfoRoomTypes = $hotelInfoRoomTypes;
        }
        return $this;
    }
    /**
     * Get HotelProvider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHotelProvider()
    {
        return isset($this->HotelProvider) ? $this->HotelProvider : null;
    }
    /**
     * Set HotelProvider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hotelProvider
     * @return \StructType\HotelInformationDefinition
     */
    public function setHotelProvider($hotelProvider = null)
    {
        // validation for constraint: string
        if (!is_null($hotelProvider) && !is_string($hotelProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelProvider)), __LINE__);
        }
        if (is_null($hotelProvider) || (is_array($hotelProvider) && empty($hotelProvider))) {
            unset($this->HotelProvider);
        } else {
            $this->HotelProvider = $hotelProvider;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\HotelInformationDefinition
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Images value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfImageItemDefinition|null
     */
    public function getImages()
    {
        return isset($this->Images) ? $this->Images : null;
    }
    /**
     * Set Images value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfImageItemDefinition $images
     * @return \StructType\HotelInformationDefinition
     */
    public function setImages(\ArrayType\ArrayOfImageItemDefinition $images = null)
    {
        if (is_null($images) || (is_array($images) && empty($images))) {
            unset($this->Images);
        } else {
            $this->Images = $images;
        }
        return $this;
    }
    /**
     * Get IsForAutoComplete value
     * @return bool|null
     */
    public function getIsForAutoComplete()
    {
        return $this->IsForAutoComplete;
    }
    /**
     * Set IsForAutoComplete value
     * @param bool $isForAutoComplete
     * @return \StructType\HotelInformationDefinition
     */
    public function setIsForAutoComplete($isForAutoComplete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForAutoComplete) && !is_bool($isForAutoComplete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isForAutoComplete)), __LINE__);
        }
        $this->IsForAutoComplete = $isForAutoComplete;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\HotelInformationDefinition
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Position value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PositionDefinition|null
     */
    public function getPosition()
    {
        return isset($this->Position) ? $this->Position : null;
    }
    /**
     * Set Position value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PositionDefinition $position
     * @return \StructType\HotelInformationDefinition
     */
    public function setPosition(\StructType\PositionDefinition $position = null)
    {
        if (is_null($position) || (is_array($position) && empty($position))) {
            unset($this->Position);
        } else {
            $this->Position = $position;
        }
        return $this;
    }
    /**
     * Get RoomTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRoomTypeDefinition|null
     */
    public function getRoomTypes()
    {
        return isset($this->RoomTypes) ? $this->RoomTypes : null;
    }
    /**
     * Set RoomTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRoomTypeDefinition $roomTypes
     * @return \StructType\HotelInformationDefinition
     */
    public function setRoomTypes(\ArrayType\ArrayOfRoomTypeDefinition $roomTypes = null)
    {
        if (is_null($roomTypes) || (is_array($roomTypes) && empty($roomTypes))) {
            unset($this->RoomTypes);
        } else {
            $this->RoomTypes = $roomTypes;
        }
        return $this;
    }
    /**
     * Get SupplierId value
     * @return int|null
     */
    public function getSupplierId()
    {
        return $this->SupplierId;
    }
    /**
     * Set SupplierId value
     * @param int $supplierId
     * @return \StructType\HotelInformationDefinition
     */
    public function setSupplierId($supplierId = null)
    {
        // validation for constraint: int
        if (!is_null($supplierId) && !is_numeric($supplierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($supplierId)), __LINE__);
        }
        $this->SupplierId = $supplierId;
        return $this;
    }
    /**
     * Get SupplierName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupplierName()
    {
        return isset($this->SupplierName) ? $this->SupplierName : null;
    }
    /**
     * Set SupplierName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supplierName
     * @return \StructType\HotelInformationDefinition
     */
    public function setSupplierName($supplierName = null)
    {
        // validation for constraint: string
        if (!is_null($supplierName) && !is_string($supplierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($supplierName)), __LINE__);
        }
        if (is_null($supplierName) || (is_array($supplierName) && empty($supplierName))) {
            unset($this->SupplierName);
        } else {
            $this->SupplierName = $supplierName;
        }
        return $this;
    }
    /**
     * Get UnifiedHotelCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnifiedHotelCode()
    {
        return isset($this->UnifiedHotelCode) ? $this->UnifiedHotelCode : null;
    }
    /**
     * Set UnifiedHotelCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unifiedHotelCode
     * @return \StructType\HotelInformationDefinition
     */
    public function setUnifiedHotelCode($unifiedHotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($unifiedHotelCode) && !is_string($unifiedHotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unifiedHotelCode)), __LINE__);
        }
        if (is_null($unifiedHotelCode) || (is_array($unifiedHotelCode) && empty($unifiedHotelCode))) {
            unset($this->UnifiedHotelCode);
        } else {
            $this->UnifiedHotelCode = $unifiedHotelCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelInformationDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
