<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChildPolicyDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ChildPolicyDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ChildPolicyDefinition extends AbstractStructBase
{
    /**
     * The ChildAFrom
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ChildAFrom;
    /**
     * The ChildATo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ChildATo;
    /**
     * The ChildBFrom
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ChildBFrom;
    /**
     * The ChildBTo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ChildBTo;
    /**
     * The MaxChildA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaxChildA;
    /**
     * The MaxChildB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaxChildB;
    /**
     * Constructor method for ChildPolicyDefinition
     * @uses ChildPolicyDefinition::setChildAFrom()
     * @uses ChildPolicyDefinition::setChildATo()
     * @uses ChildPolicyDefinition::setChildBFrom()
     * @uses ChildPolicyDefinition::setChildBTo()
     * @uses ChildPolicyDefinition::setMaxChildA()
     * @uses ChildPolicyDefinition::setMaxChildB()
     * @param int $childAFrom
     * @param int $childATo
     * @param int $childBFrom
     * @param int $childBTo
     * @param int $maxChildA
     * @param int $maxChildB
     */
    public function __construct($childAFrom = null, $childATo = null, $childBFrom = null, $childBTo = null, $maxChildA = null, $maxChildB = null)
    {
        $this
            ->setChildAFrom($childAFrom)
            ->setChildATo($childATo)
            ->setChildBFrom($childBFrom)
            ->setChildBTo($childBTo)
            ->setMaxChildA($maxChildA)
            ->setMaxChildB($maxChildB);
    }
    /**
     * Get ChildAFrom value
     * @return int|null
     */
    public function getChildAFrom()
    {
        return $this->ChildAFrom;
    }
    /**
     * Set ChildAFrom value
     * @param int $childAFrom
     * @return \StructType\ChildPolicyDefinition
     */
    public function setChildAFrom($childAFrom = null)
    {
        // validation for constraint: int
        if (!is_null($childAFrom) && !is_numeric($childAFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($childAFrom)), __LINE__);
        }
        $this->ChildAFrom = $childAFrom;
        return $this;
    }
    /**
     * Get ChildATo value
     * @return int|null
     */
    public function getChildATo()
    {
        return $this->ChildATo;
    }
    /**
     * Set ChildATo value
     * @param int $childATo
     * @return \StructType\ChildPolicyDefinition
     */
    public function setChildATo($childATo = null)
    {
        // validation for constraint: int
        if (!is_null($childATo) && !is_numeric($childATo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($childATo)), __LINE__);
        }
        $this->ChildATo = $childATo;
        return $this;
    }
    /**
     * Get ChildBFrom value
     * @return int|null
     */
    public function getChildBFrom()
    {
        return $this->ChildBFrom;
    }
    /**
     * Set ChildBFrom value
     * @param int $childBFrom
     * @return \StructType\ChildPolicyDefinition
     */
    public function setChildBFrom($childBFrom = null)
    {
        // validation for constraint: int
        if (!is_null($childBFrom) && !is_numeric($childBFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($childBFrom)), __LINE__);
        }
        $this->ChildBFrom = $childBFrom;
        return $this;
    }
    /**
     * Get ChildBTo value
     * @return int|null
     */
    public function getChildBTo()
    {
        return $this->ChildBTo;
    }
    /**
     * Set ChildBTo value
     * @param int $childBTo
     * @return \StructType\ChildPolicyDefinition
     */
    public function setChildBTo($childBTo = null)
    {
        // validation for constraint: int
        if (!is_null($childBTo) && !is_numeric($childBTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($childBTo)), __LINE__);
        }
        $this->ChildBTo = $childBTo;
        return $this;
    }
    /**
     * Get MaxChildA value
     * @return int|null
     */
    public function getMaxChildA()
    {
        return $this->MaxChildA;
    }
    /**
     * Set MaxChildA value
     * @param int $maxChildA
     * @return \StructType\ChildPolicyDefinition
     */
    public function setMaxChildA($maxChildA = null)
    {
        // validation for constraint: int
        if (!is_null($maxChildA) && !is_numeric($maxChildA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxChildA)), __LINE__);
        }
        $this->MaxChildA = $maxChildA;
        return $this;
    }
    /**
     * Get MaxChildB value
     * @return int|null
     */
    public function getMaxChildB()
    {
        return $this->MaxChildB;
    }
    /**
     * Set MaxChildB value
     * @param int $maxChildB
     * @return \StructType\ChildPolicyDefinition
     */
    public function setMaxChildB($maxChildB = null)
    {
        // validation for constraint: int
        if (!is_null($maxChildB) && !is_numeric($maxChildB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxChildB)), __LINE__);
        }
        $this->MaxChildB = $maxChildB;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChildPolicyDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
