<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CallHistoryDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CallHistoryDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class CallHistoryDefinition extends ClientHistoryDefinition
{
    /**
     * The AttendedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AttendedBy;
    /**
     * The FilePath
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FilePath;
    /**
     * The IdItineraries
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $IdItineraries;
    /**
     * The IsAdmin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAdmin;
    /**
     * The LoginId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LoginId;
    /**
     * Constructor method for CallHistoryDefinition
     * @uses CallHistoryDefinition::setAttendedBy()
     * @uses CallHistoryDefinition::setFilePath()
     * @uses CallHistoryDefinition::setIdItineraries()
     * @uses CallHistoryDefinition::setIsAdmin()
     * @uses CallHistoryDefinition::setLoginId()
     * @param string $attendedBy
     * @param string $filePath
     * @param \ArrayType\ArrayOfint $idItineraries
     * @param bool $isAdmin
     * @param int $loginId
     */
    public function __construct($attendedBy = null, $filePath = null, \ArrayType\ArrayOfint $idItineraries = null, $isAdmin = null, $loginId = null)
    {
        $this
            ->setAttendedBy($attendedBy)
            ->setFilePath($filePath)
            ->setIdItineraries($idItineraries)
            ->setIsAdmin($isAdmin)
            ->setLoginId($loginId);
    }
    /**
     * Get AttendedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttendedBy()
    {
        return isset($this->AttendedBy) ? $this->AttendedBy : null;
    }
    /**
     * Set AttendedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attendedBy
     * @return \StructType\CallHistoryDefinition
     */
    public function setAttendedBy($attendedBy = null)
    {
        // validation for constraint: string
        if (!is_null($attendedBy) && !is_string($attendedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attendedBy)), __LINE__);
        }
        if (is_null($attendedBy) || (is_array($attendedBy) && empty($attendedBy))) {
            unset($this->AttendedBy);
        } else {
            $this->AttendedBy = $attendedBy;
        }
        return $this;
    }
    /**
     * Get FilePath value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFilePath()
    {
        return isset($this->FilePath) ? $this->FilePath : null;
    }
    /**
     * Set FilePath value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $filePath
     * @return \StructType\CallHistoryDefinition
     */
    public function setFilePath($filePath = null)
    {
        // validation for constraint: string
        if (!is_null($filePath) && !is_string($filePath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filePath)), __LINE__);
        }
        if (is_null($filePath) || (is_array($filePath) && empty($filePath))) {
            unset($this->FilePath);
        } else {
            $this->FilePath = $filePath;
        }
        return $this;
    }
    /**
     * Get IdItineraries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getIdItineraries()
    {
        return isset($this->IdItineraries) ? $this->IdItineraries : null;
    }
    /**
     * Set IdItineraries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $idItineraries
     * @return \StructType\CallHistoryDefinition
     */
    public function setIdItineraries(\ArrayType\ArrayOfint $idItineraries = null)
    {
        if (is_null($idItineraries) || (is_array($idItineraries) && empty($idItineraries))) {
            unset($this->IdItineraries);
        } else {
            $this->IdItineraries = $idItineraries;
        }
        return $this;
    }
    /**
     * Get IsAdmin value
     * @return bool|null
     */
    public function getIsAdmin()
    {
        return $this->IsAdmin;
    }
    /**
     * Set IsAdmin value
     * @param bool $isAdmin
     * @return \StructType\CallHistoryDefinition
     */
    public function setIsAdmin($isAdmin = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAdmin) && !is_bool($isAdmin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAdmin)), __LINE__);
        }
        $this->IsAdmin = $isAdmin;
        return $this;
    }
    /**
     * Get LoginId value
     * @return int|null
     */
    public function getLoginId()
    {
        return $this->LoginId;
    }
    /**
     * Set LoginId value
     * @param int $loginId
     * @return \StructType\CallHistoryDefinition
     */
    public function setLoginId($loginId = null)
    {
        // validation for constraint: int
        if (!is_null($loginId) && !is_numeric($loginId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($loginId)), __LINE__);
        }
        $this->LoginId = $loginId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CallHistoryDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
