<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BaseRequest
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class BaseRequest extends AbstractStructBase
{
    /**
     * The ModuleType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ModuleType;
    /**
     * The RequestSettings
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RequestSettingsDefinition
     */
    public $RequestSettings;
    /**
     * The SessionToken
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SessionToken;
    /**
     * Constructor method for BaseRequest
     * @uses BaseRequest::setModuleType()
     * @uses BaseRequest::setRequestSettings()
     * @uses BaseRequest::setSessionToken()
     * @param string $moduleType
     * @param \StructType\RequestSettingsDefinition $requestSettings
     * @param string $sessionToken
     */
    public function __construct($moduleType = null, \StructType\RequestSettingsDefinition $requestSettings = null, $sessionToken = null)
    {
        $this
            ->setModuleType($moduleType)
            ->setRequestSettings($requestSettings)
            ->setSessionToken($sessionToken);
    }
    /**
     * Get ModuleType value
     * @return string|null
     */
    public function getModuleType()
    {
        return $this->ModuleType;
    }
    /**
     * Set ModuleType value
     * @uses \EnumType\ModuleType::valueIsValid()
     * @uses \EnumType\ModuleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $moduleType
     * @return \StructType\BaseRequest
     */
    public function setModuleType($moduleType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ModuleType::valueIsValid($moduleType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $moduleType, implode(', ', \EnumType\ModuleType::getValidValues())), __LINE__);
        }
        $this->ModuleType = $moduleType;
        return $this;
    }
    /**
     * Get RequestSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RequestSettingsDefinition|null
     */
    public function getRequestSettings()
    {
        return isset($this->RequestSettings) ? $this->RequestSettings : null;
    }
    /**
     * Set RequestSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RequestSettingsDefinition $requestSettings
     * @return \StructType\BaseRequest
     */
    public function setRequestSettings(\StructType\RequestSettingsDefinition $requestSettings = null)
    {
        if (is_null($requestSettings) || (is_array($requestSettings) && empty($requestSettings))) {
            unset($this->RequestSettings);
        } else {
            $this->RequestSettings = $requestSettings;
        }
        return $this;
    }
    /**
     * Get SessionToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSessionToken()
    {
        return isset($this->SessionToken) ? $this->SessionToken : null;
    }
    /**
     * Set SessionToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sessionToken
     * @return \StructType\BaseRequest
     */
    public function setSessionToken($sessionToken = null)
    {
        // validation for constraint: string
        if (!is_null($sessionToken) && !is_string($sessionToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionToken)), __LINE__);
        }
        if (is_null($sessionToken) || (is_array($sessionToken) && empty($sessionToken))) {
            unset($this->SessionToken);
        } else {
            $this->SessionToken = $sessionToken;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaseRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
