<?php

namespace EnumType;

/**
 * This class stands for ProfileHierarchyType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProfileHierarchyType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ProfileHierarchyType
{
    /**
     * Constant for value 'Customer'
     * @return string 'Customer'
     */
    const VALUE_CUSTOMER = 'Customer';
    /**
     * Constant for value 'Supplier'
     * @return string 'Supplier'
     */
    const VALUE_SUPPLIER = 'Supplier';
    /**
     * Constant for value 'Provider'
     * @return string 'Provider'
     */
    const VALUE_PROVIDER = 'Provider';
    /**
     * Constant for value 'Employee'
     * @return string 'Employee'
     */
    const VALUE_EMPLOYEE = 'Employee';
    /**
     * Constant for value 'Passenger'
     * @return string 'Passenger'
     */
    const VALUE_PASSENGER = 'Passenger';
    /**
     * Constant for value 'Prospect'
     * @return string 'Prospect'
     */
    const VALUE_PROSPECT = 'Prospect';
    /**
     * Constant for value 'Guest'
     * @return string 'Guest'
     */
    const VALUE_GUEST = 'Guest';
    /**
     * Constant for value 'Owner'
     * @return string 'Owner'
     */
    const VALUE_OWNER = 'Owner';
    /**
     * Constant for value 'BuyingAgent'
     * @return string 'BuyingAgent'
     */
    const VALUE_BUYING_AGENT = 'BuyingAgent';
    /**
     * Constant for value 'Contact'
     * @return string 'Contact'
     */
    const VALUE_CONTACT = 'Contact';
    /**
     * Constant for value 'CompanyOfGroup'
     * @return string 'CompanyOfGroup'
     */
    const VALUE_COMPANY_OF_GROUP = 'CompanyOfGroup';
    /**
     * Constant for value 'CustomerOfCustomer'
     * @return string 'CustomerOfCustomer'
     */
    const VALUE_CUSTOMER_OF_CUSTOMER = 'CustomerOfCustomer';
    /**
     * Constant for value 'Supervisor'
     * @return string 'Supervisor'
     */
    const VALUE_SUPERVISOR = 'Supervisor';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CUSTOMER
     * @uses self::VALUE_SUPPLIER
     * @uses self::VALUE_PROVIDER
     * @uses self::VALUE_EMPLOYEE
     * @uses self::VALUE_PASSENGER
     * @uses self::VALUE_PROSPECT
     * @uses self::VALUE_GUEST
     * @uses self::VALUE_OWNER
     * @uses self::VALUE_BUYING_AGENT
     * @uses self::VALUE_CONTACT
     * @uses self::VALUE_COMPANY_OF_GROUP
     * @uses self::VALUE_CUSTOMER_OF_CUSTOMER
     * @uses self::VALUE_SUPERVISOR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CUSTOMER,
            self::VALUE_SUPPLIER,
            self::VALUE_PROVIDER,
            self::VALUE_EMPLOYEE,
            self::VALUE_PASSENGER,
            self::VALUE_PROSPECT,
            self::VALUE_GUEST,
            self::VALUE_OWNER,
            self::VALUE_BUYING_AGENT,
            self::VALUE_CONTACT,
            self::VALUE_COMPANY_OF_GROUP,
            self::VALUE_CUSTOMER_OF_CUSTOMER,
            self::VALUE_SUPERVISOR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
