<?php

namespace EnumType;

/**
 * This class stands for ProfileAddressType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProfileAddressType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ProfileAddressType
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Mail'
     * @return string 'Mail'
     */
    const VALUE_MAIL = 'Mail';
    /**
     * Constant for value 'Invoice'
     * @return string 'Invoice'
     */
    const VALUE_INVOICE = 'Invoice';
    /**
     * Constant for value 'Residential'
     * @return string 'Residential'
     */
    const VALUE_RESIDENTIAL = 'Residential';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_MAIL
     * @uses self::VALUE_INVOICE
     * @uses self::VALUE_RESIDENTIAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_MAIL,
            self::VALUE_INVOICE,
            self::VALUE_RESIDENTIAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
