<?php

namespace EnumType;

/**
 * This class stands for ModuleType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ModuleType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ModuleType
{
    /**
     * Constant for value 'Extended'
     * @return string 'Extended'
     */
    const VALUE_EXTENDED = 'Extended';
    /**
     * Constant for value 'General'
     * @return string 'General'
     */
    const VALUE_GENERAL = 'General';
    /**
     * Constant for value 'AirFare'
     * @return string 'AirFare'
     */
    const VALUE_AIR_FARE = 'AirFare';
    /**
     * Constant for value 'Assistance'
     * @return string 'Assistance'
     */
    const VALUE_ASSISTANCE = 'Assistance';
    /**
     * Constant for value 'Configuration'
     * @return string 'Configuration'
     */
    const VALUE_CONFIGURATION = 'Configuration';
    /**
     * Constant for value 'TicketFee'
     * @return string 'TicketFee'
     */
    const VALUE_TICKET_FEE = 'TicketFee';
    /**
     * Constant for value 'AgencyFee'
     * @return string 'AgencyFee'
     */
    const VALUE_AGENCY_FEE = 'AgencyFee';
    /**
     * Constant for value 'Hotel'
     * @return string 'Hotel'
     */
    const VALUE_HOTEL = 'Hotel';
    /**
     * Constant for value 'Miscellaneous'
     * @return string 'Miscellaneous'
     */
    const VALUE_MISCELLANEOUS = 'Miscellaneous';
    /**
     * Constant for value 'Package'
     * @return string 'Package'
     */
    const VALUE_PACKAGE = 'Package';
    /**
     * Constant for value 'PaymentForm'
     * @return string 'PaymentForm'
     */
    const VALUE_PAYMENT_FORM = 'PaymentForm';
    /**
     * Constant for value 'Promotion'
     * @return string 'Promotion'
     */
    const VALUE_PROMOTION = 'Promotion';
    /**
     * Constant for value 'AirReservation'
     * @return string 'AirReservation'
     */
    const VALUE_AIR_RESERVATION = 'AirReservation';
    /**
     * Constant for value 'HotelReservation'
     * @return string 'HotelReservation'
     */
    const VALUE_HOTEL_RESERVATION = 'HotelReservation';
    /**
     * Constant for value 'Rule'
     * @return string 'Rule'
     */
    const VALUE_RULE = 'Rule';
    /**
     * Constant for value 'AdminUsers'
     * @return string 'AdminUsers'
     */
    const VALUE_ADMIN_USERS = 'AdminUsers';
    /**
     * Constant for value 'ProviderInfo'
     * @return string 'ProviderInfo'
     */
    const VALUE_PROVIDER_INFO = 'ProviderInfo';
    /**
     * Constant for value 'NetBooking'
     * @return string 'NetBooking'
     */
    const VALUE_NET_BOOKING = 'NetBooking';
    /**
     * Constant for value 'NetBookingHotel'
     * @return string 'NetBookingHotel'
     */
    const VALUE_NET_BOOKING_HOTEL = 'NetBookingHotel';
    /**
     * Constant for value 'NetPackaging'
     * @return string 'NetPackaging'
     */
    const VALUE_NET_PACKAGING = 'NetPackaging';
    /**
     * Constant for value 'NetMisc'
     * @return string 'NetMisc'
     */
    const VALUE_NET_MISC = 'NetMisc';
    /**
     * Constant for value 'NetFareViewer'
     * @return string 'NetFareViewer'
     */
    const VALUE_NET_FARE_VIEWER = 'NetFareViewer';
    /**
     * Constant for value 'NetAssistance'
     * @return string 'NetAssistance'
     */
    const VALUE_NET_ASSISTANCE = 'NetAssistance';
    /**
     * Constant for value 'NetAgent'
     * @return string 'NetAgent'
     */
    const VALUE_NET_AGENT = 'NetAgent';
    /**
     * Constant for value 'TravelItinerary'
     * @return string 'TravelItinerary'
     */
    const VALUE_TRAVEL_ITINERARY = 'TravelItinerary';
    /**
     * Constant for value 'Car'
     * @return string 'Car'
     */
    const VALUE_CAR = 'Car';
    /**
     * Constant for value 'NetCar'
     * @return string 'NetCar'
     */
    const VALUE_NET_CAR = 'NetCar';
    /**
     * Constant for value 'HotelFare'
     * @return string 'HotelFare'
     */
    const VALUE_HOTEL_FARE = 'HotelFare';
    /**
     * Constant for value 'Cruiser'
     * @return string 'Cruiser'
     */
    const VALUE_CRUISER = 'Cruiser';
    /**
     * Constant for value 'NetCruiser'
     * @return string 'NetCruiser'
     */
    const VALUE_NET_CRUISER = 'NetCruiser';
    /**
     * Constant for value 'NetTerminal'
     * @return string 'NetTerminal'
     */
    const VALUE_NET_TERMINAL = 'NetTerminal';
    /**
     * Constant for value 'BusinessAccount'
     * @return string 'BusinessAccount'
     */
    const VALUE_BUSINESS_ACCOUNT = 'BusinessAccount';
    /**
     * Constant for value 'Inventory'
     * @return string 'Inventory'
     */
    const VALUE_INVENTORY = 'Inventory';
    /**
     * Constant for value 'NetFulfillment'
     * @return string 'NetFulfillment'
     */
    const VALUE_NET_FULFILLMENT = 'NetFulfillment';
    /**
     * Constant for value 'Profile'
     * @return string 'Profile'
     */
    const VALUE_PROFILE = 'Profile';
    /**
     * Constant for value 'DestinationGuide'
     * @return string 'DestinationGuide'
     */
    const VALUE_DESTINATION_GUIDE = 'DestinationGuide';
    /**
     * Constant for value 'NetBookingCar'
     * @return string 'NetBookingCar'
     */
    const VALUE_NET_BOOKING_CAR = 'NetBookingCar';
    /**
     * Constant for value 'VehicleReservation'
     * @return string 'VehicleReservation'
     */
    const VALUE_VEHICLE_RESERVATION = 'VehicleReservation';
    /**
     * Constant for value 'CreditCard'
     * @return string 'CreditCard'
     */
    const VALUE_CREDIT_CARD = 'CreditCard';
    /**
     * Constant for value 'Seed'
     * @return string 'Seed'
     */
    const VALUE_SEED = 'Seed';
    /**
     * Constant for value 'TravelExtraInfo'
     * @return string 'TravelExtraInfo'
     */
    const VALUE_TRAVEL_EXTRA_INFO = 'TravelExtraInfo';
    /**
     * Constant for value 'TravelExtraFare'
     * @return string 'TravelExtraFare'
     */
    const VALUE_TRAVEL_EXTRA_FARE = 'TravelExtraFare';
    /**
     * Constant for value 'NetBookingExtra'
     * @return string 'NetBookingExtra'
     */
    const VALUE_NET_BOOKING_EXTRA = 'NetBookingExtra';
    /**
     * Constant for value 'TravelExtraReservation'
     * @return string 'TravelExtraReservation'
     */
    const VALUE_TRAVEL_EXTRA_RESERVATION = 'TravelExtraReservation';
    /**
     * Constant for value 'Flows'
     * @return string 'Flows'
     */
    const VALUE_FLOWS = 'Flows';
    /**
     * Constant for value 'Charters'
     * @return string 'Charters'
     */
    const VALUE_CHARTERS = 'Charters';
    /**
     * Constant for value 'Call'
     * @return string 'Call'
     */
    const VALUE_CALL = 'Call';
    /**
     * Constant for value 'Reports'
     * @return string 'Reports'
     */
    const VALUE_REPORTS = 'Reports';
    /**
     * Constant for value 'QuoteContainer'
     * @return string 'QuoteContainer'
     */
    const VALUE_QUOTE_CONTAINER = 'QuoteContainer';
    /**
     * Constant for value 'Case'
     * @return string 'Case'
     */
    const VALUE_CASE = 'Case';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EXTENDED
     * @uses self::VALUE_GENERAL
     * @uses self::VALUE_AIR_FARE
     * @uses self::VALUE_ASSISTANCE
     * @uses self::VALUE_CONFIGURATION
     * @uses self::VALUE_TICKET_FEE
     * @uses self::VALUE_AGENCY_FEE
     * @uses self::VALUE_HOTEL
     * @uses self::VALUE_MISCELLANEOUS
     * @uses self::VALUE_PACKAGE
     * @uses self::VALUE_PAYMENT_FORM
     * @uses self::VALUE_PROMOTION
     * @uses self::VALUE_AIR_RESERVATION
     * @uses self::VALUE_HOTEL_RESERVATION
     * @uses self::VALUE_RULE
     * @uses self::VALUE_ADMIN_USERS
     * @uses self::VALUE_PROVIDER_INFO
     * @uses self::VALUE_NET_BOOKING
     * @uses self::VALUE_NET_BOOKING_HOTEL
     * @uses self::VALUE_NET_PACKAGING
     * @uses self::VALUE_NET_MISC
     * @uses self::VALUE_NET_FARE_VIEWER
     * @uses self::VALUE_NET_ASSISTANCE
     * @uses self::VALUE_NET_AGENT
     * @uses self::VALUE_TRAVEL_ITINERARY
     * @uses self::VALUE_CAR
     * @uses self::VALUE_NET_CAR
     * @uses self::VALUE_HOTEL_FARE
     * @uses self::VALUE_CRUISER
     * @uses self::VALUE_NET_CRUISER
     * @uses self::VALUE_NET_TERMINAL
     * @uses self::VALUE_BUSINESS_ACCOUNT
     * @uses self::VALUE_INVENTORY
     * @uses self::VALUE_NET_FULFILLMENT
     * @uses self::VALUE_PROFILE
     * @uses self::VALUE_DESTINATION_GUIDE
     * @uses self::VALUE_NET_BOOKING_CAR
     * @uses self::VALUE_VEHICLE_RESERVATION
     * @uses self::VALUE_CREDIT_CARD
     * @uses self::VALUE_SEED
     * @uses self::VALUE_TRAVEL_EXTRA_INFO
     * @uses self::VALUE_TRAVEL_EXTRA_FARE
     * @uses self::VALUE_NET_BOOKING_EXTRA
     * @uses self::VALUE_TRAVEL_EXTRA_RESERVATION
     * @uses self::VALUE_FLOWS
     * @uses self::VALUE_CHARTERS
     * @uses self::VALUE_CALL
     * @uses self::VALUE_REPORTS
     * @uses self::VALUE_QUOTE_CONTAINER
     * @uses self::VALUE_CASE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EXTENDED,
            self::VALUE_GENERAL,
            self::VALUE_AIR_FARE,
            self::VALUE_ASSISTANCE,
            self::VALUE_CONFIGURATION,
            self::VALUE_TICKET_FEE,
            self::VALUE_AGENCY_FEE,
            self::VALUE_HOTEL,
            self::VALUE_MISCELLANEOUS,
            self::VALUE_PACKAGE,
            self::VALUE_PAYMENT_FORM,
            self::VALUE_PROMOTION,
            self::VALUE_AIR_RESERVATION,
            self::VALUE_HOTEL_RESERVATION,
            self::VALUE_RULE,
            self::VALUE_ADMIN_USERS,
            self::VALUE_PROVIDER_INFO,
            self::VALUE_NET_BOOKING,
            self::VALUE_NET_BOOKING_HOTEL,
            self::VALUE_NET_PACKAGING,
            self::VALUE_NET_MISC,
            self::VALUE_NET_FARE_VIEWER,
            self::VALUE_NET_ASSISTANCE,
            self::VALUE_NET_AGENT,
            self::VALUE_TRAVEL_ITINERARY,
            self::VALUE_CAR,
            self::VALUE_NET_CAR,
            self::VALUE_HOTEL_FARE,
            self::VALUE_CRUISER,
            self::VALUE_NET_CRUISER,
            self::VALUE_NET_TERMINAL,
            self::VALUE_BUSINESS_ACCOUNT,
            self::VALUE_INVENTORY,
            self::VALUE_NET_FULFILLMENT,
            self::VALUE_PROFILE,
            self::VALUE_DESTINATION_GUIDE,
            self::VALUE_NET_BOOKING_CAR,
            self::VALUE_VEHICLE_RESERVATION,
            self::VALUE_CREDIT_CARD,
            self::VALUE_SEED,
            self::VALUE_TRAVEL_EXTRA_INFO,
            self::VALUE_TRAVEL_EXTRA_FARE,
            self::VALUE_NET_BOOKING_EXTRA,
            self::VALUE_TRAVEL_EXTRA_RESERVATION,
            self::VALUE_FLOWS,
            self::VALUE_CHARTERS,
            self::VALUE_CALL,
            self::VALUE_REPORTS,
            self::VALUE_QUOTE_CONTAINER,
            self::VALUE_CASE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
