<?php

namespace EnumType;

/**
 * This class stands for HotelPurchaseStatusType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:HotelPurchaseStatusType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class HotelPurchaseStatusType
{
    /**
     * Constant for value 'ShoppingCart'
     * @return string 'ShoppingCart'
     */
    const VALUE_SHOPPING_CART = 'ShoppingCart';
    /**
     * Constant for value 'Book'
     * @return string 'Book'
     */
    const VALUE_BOOK = 'Book';
    /**
     * Constant for value 'OnlyUpdate'
     * @return string 'OnlyUpdate'
     */
    const VALUE_ONLY_UPDATE = 'OnlyUpdate';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SHOPPING_CART
     * @uses self::VALUE_BOOK
     * @uses self::VALUE_ONLY_UPDATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SHOPPING_CART,
            self::VALUE_BOOK,
            self::VALUE_ONLY_UPDATE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
