<?php

namespace EnumType;

/**
 * This class stands for BedType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BedType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class BedType
{
    /**
     * Constant for value 'NotRelevant'
     * @return string 'NotRelevant'
     */
    const VALUE_NOT_RELEVANT = 'NotRelevant';
    /**
     * Constant for value 'TwinBeds'
     * @return string 'TwinBeds'
     */
    const VALUE_TWIN_BEDS = 'TwinBeds';
    /**
     * Constant for value 'DoubleBed'
     * @return string 'DoubleBed'
     */
    const VALUE_DOUBLE_BED = 'DoubleBed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_RELEVANT
     * @uses self::VALUE_TWIN_BEDS
     * @uses self::VALUE_DOUBLE_BED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_RELEVANT,
            self::VALUE_TWIN_BEDS,
            self::VALUE_DOUBLE_BED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
