<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfImageItemDefinition ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfImageItemDefinition
 * @subpackage Arrays
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ArrayOfImageItemDefinition extends AbstractStructArrayBase
{
    /**
     * The ImageItemDefinition
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ImageItemDefinition[]
     */
    public $ImageItemDefinition;
    /**
     * Constructor method for ArrayOfImageItemDefinition
     * @uses ArrayOfImageItemDefinition::setImageItemDefinition()
     * @param \StructType\ImageItemDefinition[] $imageItemDefinition
     */
    public function __construct(array $imageItemDefinition = array())
    {
        $this
            ->setImageItemDefinition($imageItemDefinition);
    }
    /**
     * Get ImageItemDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ImageItemDefinition[]|null
     */
    public function getImageItemDefinition()
    {
        return isset($this->ImageItemDefinition) ? $this->ImageItemDefinition : null;
    }
    /**
     * Set ImageItemDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ImageItemDefinition[] $imageItemDefinition
     * @return \ArrayType\ArrayOfImageItemDefinition
     */
    public function setImageItemDefinition(array $imageItemDefinition = array())
    {
        foreach ($imageItemDefinition as $arrayOfImageItemDefinitionImageItemDefinitionItem) {
            // validation for constraint: itemType
            if (!$arrayOfImageItemDefinitionImageItemDefinitionItem instanceof \StructType\ImageItemDefinition) {
                throw new \InvalidArgumentException(sprintf('The ImageItemDefinition property can only contain items of \StructType\ImageItemDefinition, "%s" given', is_object($arrayOfImageItemDefinitionImageItemDefinitionItem) ? get_class($arrayOfImageItemDefinitionImageItemDefinitionItem) : gettype($arrayOfImageItemDefinitionImageItemDefinitionItem)), __LINE__);
            }
        }
        if (is_null($imageItemDefinition) || (is_array($imageItemDefinition) && empty($imageItemDefinition))) {
            unset($this->ImageItemDefinition);
        } else {
            $this->ImageItemDefinition = $imageItemDefinition;
        }
        return $this;
    }
    /**
     * Add item to ImageItemDefinition value
     * @throws \InvalidArgumentException
     * @param \StructType\ImageItemDefinition $item
     * @return \ArrayType\ArrayOfImageItemDefinition
     */
    public function addToImageItemDefinition(\StructType\ImageItemDefinition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ImageItemDefinition) {
            throw new \InvalidArgumentException(sprintf('The ImageItemDefinition property can only contain items of \StructType\ImageItemDefinition, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ImageItemDefinition[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ImageItemDefinition|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ImageItemDefinition|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ImageItemDefinition|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ImageItemDefinition|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ImageItemDefinition|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ImageItemDefinition
     */
    public function getAttributeName()
    {
        return 'ImageItemDefinition';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfImageItemDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
