<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservationTracerBaseDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ReservationTracerBaseDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ReservationTracerBaseDefinition extends AbstractStructBase
{
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The IsAdmin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAdmin;
    /**
     * The IsGuest
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsGuest;
    /**
     * The Login
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BaseLoginDefinition
     */
    public $Login;
    /**
     * Constructor method for ReservationTracerBaseDefinition
     * @uses ReservationTracerBaseDefinition::setDate()
     * @uses ReservationTracerBaseDefinition::setIsAdmin()
     * @uses ReservationTracerBaseDefinition::setIsGuest()
     * @uses ReservationTracerBaseDefinition::setLogin()
     * @param string $date
     * @param bool $isAdmin
     * @param bool $isGuest
     * @param \StructType\BaseLoginDefinition $login
     */
    public function __construct($date = null, $isAdmin = null, $isGuest = null, \StructType\BaseLoginDefinition $login = null)
    {
        $this
            ->setDate($date)
            ->setIsAdmin($isAdmin)
            ->setIsGuest($isGuest)
            ->setLogin($login);
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\ReservationTracerBaseDefinition
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get IsAdmin value
     * @return bool|null
     */
    public function getIsAdmin()
    {
        return $this->IsAdmin;
    }
    /**
     * Set IsAdmin value
     * @param bool $isAdmin
     * @return \StructType\ReservationTracerBaseDefinition
     */
    public function setIsAdmin($isAdmin = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAdmin) && !is_bool($isAdmin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAdmin)), __LINE__);
        }
        $this->IsAdmin = $isAdmin;
        return $this;
    }
    /**
     * Get IsGuest value
     * @return bool|null
     */
    public function getIsGuest()
    {
        return $this->IsGuest;
    }
    /**
     * Set IsGuest value
     * @param bool $isGuest
     * @return \StructType\ReservationTracerBaseDefinition
     */
    public function setIsGuest($isGuest = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGuest) && !is_bool($isGuest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isGuest)), __LINE__);
        }
        $this->IsGuest = $isGuest;
        return $this;
    }
    /**
     * Get Login value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BaseLoginDefinition|null
     */
    public function getLogin()
    {
        return isset($this->Login) ? $this->Login : null;
    }
    /**
     * Set Login value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BaseLoginDefinition $login
     * @return \StructType\ReservationTracerBaseDefinition
     */
    public function setLogin(\StructType\BaseLoginDefinition $login = null)
    {
        if (is_null($login) || (is_array($login) && empty($login))) {
            unset($this->Login);
        } else {
            $this->Login = $login;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReservationTracerBaseDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
