<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProviderInfoDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProviderInfoDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ProviderInfoDefinition extends ProfileBaseDefinition
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The BlackList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $BlackList;
    /**
     * The DKNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DKNumber;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsDeleted;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Products
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProductDefinition
     */
    public $Products;
    /**
     * Constructor method for ProviderInfoDefinition
     * @uses ProviderInfoDefinition::setActive()
     * @uses ProviderInfoDefinition::setBlackList()
     * @uses ProviderInfoDefinition::setDKNumber()
     * @uses ProviderInfoDefinition::setId()
     * @uses ProviderInfoDefinition::setIsDeleted()
     * @uses ProviderInfoDefinition::setName()
     * @uses ProviderInfoDefinition::setProducts()
     * @param bool $active
     * @param bool $blackList
     * @param string $dKNumber
     * @param int $id
     * @param bool $isDeleted
     * @param string $name
     * @param \ArrayType\ArrayOfProductDefinition $products
     */
    public function __construct($active = null, $blackList = null, $dKNumber = null, $id = null, $isDeleted = null, $name = null, \ArrayType\ArrayOfProductDefinition $products = null)
    {
        $this
            ->setActive($active)
            ->setBlackList($blackList)
            ->setDKNumber($dKNumber)
            ->setId($id)
            ->setIsDeleted($isDeleted)
            ->setName($name)
            ->setProducts($products);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\ProviderInfoDefinition
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get BlackList value
     * @return bool|null
     */
    public function getBlackList()
    {
        return $this->BlackList;
    }
    /**
     * Set BlackList value
     * @param bool $blackList
     * @return \StructType\ProviderInfoDefinition
     */
    public function setBlackList($blackList = null)
    {
        // validation for constraint: boolean
        if (!is_null($blackList) && !is_bool($blackList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($blackList)), __LINE__);
        }
        $this->BlackList = $blackList;
        return $this;
    }
    /**
     * Get DKNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDKNumber()
    {
        return isset($this->DKNumber) ? $this->DKNumber : null;
    }
    /**
     * Set DKNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dKNumber
     * @return \StructType\ProviderInfoDefinition
     */
    public function setDKNumber($dKNumber = null)
    {
        // validation for constraint: string
        if (!is_null($dKNumber) && !is_string($dKNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dKNumber)), __LINE__);
        }
        if (is_null($dKNumber) || (is_array($dKNumber) && empty($dKNumber))) {
            unset($this->DKNumber);
        } else {
            $this->DKNumber = $dKNumber;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\ProviderInfoDefinition
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IsDeleted value
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return $this->IsDeleted;
    }
    /**
     * Set IsDeleted value
     * @param bool $isDeleted
     * @return \StructType\ProviderInfoDefinition
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDeleted)), __LINE__);
        }
        $this->IsDeleted = $isDeleted;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\ProviderInfoDefinition
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Products value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProductDefinition|null
     */
    public function getProducts()
    {
        return isset($this->Products) ? $this->Products : null;
    }
    /**
     * Set Products value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProductDefinition $products
     * @return \StructType\ProviderInfoDefinition
     */
    public function setProducts(\ArrayType\ArrayOfProductDefinition $products = null)
    {
        if (is_null($products) || (is_array($products) && empty($products))) {
            unset($this->Products);
        } else {
            $this->Products = $products;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProviderInfoDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
