<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfileCompanyDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProfileCompanyDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ProfileCompanyDefinition extends ProfileBaseDefinition
{
    /**
     * The ActionTypeImage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActionTypeImage;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The CorporateName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CorporateName;
    /**
     * The DKNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DKNumber;
    /**
     * The Iata
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Iata;
    /**
     * The Image
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProfileImageDefinition
     */
    public $Image;
    /**
     * The IndustryFieldId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IndustryFieldId;
    /**
     * The IsCorporate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsCorporate;
    /**
     * The IsPrivateBranch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsPrivateBranch;
    /**
     * The LegalName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LegalName;
    /**
     * The Pcc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Pcc;
    /**
     * The Queue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Queue;
    /**
     * The TerminalDataList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTerminalDataDefinition
     */
    public $TerminalDataList;
    /**
     * Constructor method for ProfileCompanyDefinition
     * @uses ProfileCompanyDefinition::setActionTypeImage()
     * @uses ProfileCompanyDefinition::setCode()
     * @uses ProfileCompanyDefinition::setCorporateName()
     * @uses ProfileCompanyDefinition::setDKNumber()
     * @uses ProfileCompanyDefinition::setIata()
     * @uses ProfileCompanyDefinition::setImage()
     * @uses ProfileCompanyDefinition::setIndustryFieldId()
     * @uses ProfileCompanyDefinition::setIsCorporate()
     * @uses ProfileCompanyDefinition::setIsPrivateBranch()
     * @uses ProfileCompanyDefinition::setLegalName()
     * @uses ProfileCompanyDefinition::setPcc()
     * @uses ProfileCompanyDefinition::setQueue()
     * @uses ProfileCompanyDefinition::setTerminalDataList()
     * @param string $actionTypeImage
     * @param string $code
     * @param string $corporateName
     * @param string $dKNumber
     * @param string $iata
     * @param \StructType\ProfileImageDefinition $image
     * @param string $industryFieldId
     * @param bool $isCorporate
     * @param bool $isPrivateBranch
     * @param string $legalName
     * @param string $pcc
     * @param string $queue
     * @param \ArrayType\ArrayOfTerminalDataDefinition $terminalDataList
     */
    public function __construct($actionTypeImage = null, $code = null, $corporateName = null, $dKNumber = null, $iata = null, \StructType\ProfileImageDefinition $image = null, $industryFieldId = null, $isCorporate = null, $isPrivateBranch = null, $legalName = null, $pcc = null, $queue = null, \ArrayType\ArrayOfTerminalDataDefinition $terminalDataList = null)
    {
        $this
            ->setActionTypeImage($actionTypeImage)
            ->setCode($code)
            ->setCorporateName($corporateName)
            ->setDKNumber($dKNumber)
            ->setIata($iata)
            ->setImage($image)
            ->setIndustryFieldId($industryFieldId)
            ->setIsCorporate($isCorporate)
            ->setIsPrivateBranch($isPrivateBranch)
            ->setLegalName($legalName)
            ->setPcc($pcc)
            ->setQueue($queue)
            ->setTerminalDataList($terminalDataList);
    }
    /**
     * Get ActionTypeImage value
     * @return string|null
     */
    public function getActionTypeImage()
    {
        return $this->ActionTypeImage;
    }
    /**
     * Set ActionTypeImage value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionTypeImage
     * @return \StructType\ProfileCompanyDefinition
     */
    public function setActionTypeImage($actionTypeImage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($actionTypeImage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $actionTypeImage, implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->ActionTypeImage = $actionTypeImage;
        return $this;
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \StructType\ProfileCompanyDefinition
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get CorporateName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCorporateName()
    {
        return isset($this->CorporateName) ? $this->CorporateName : null;
    }
    /**
     * Set CorporateName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $corporateName
     * @return \StructType\ProfileCompanyDefinition
     */
    public function setCorporateName($corporateName = null)
    {
        // validation for constraint: string
        if (!is_null($corporateName) && !is_string($corporateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($corporateName)), __LINE__);
        }
        if (is_null($corporateName) || (is_array($corporateName) && empty($corporateName))) {
            unset($this->CorporateName);
        } else {
            $this->CorporateName = $corporateName;
        }
        return $this;
    }
    /**
     * Get DKNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDKNumber()
    {
        return isset($this->DKNumber) ? $this->DKNumber : null;
    }
    /**
     * Set DKNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dKNumber
     * @return \StructType\ProfileCompanyDefinition
     */
    public function setDKNumber($dKNumber = null)
    {
        // validation for constraint: string
        if (!is_null($dKNumber) && !is_string($dKNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dKNumber)), __LINE__);
        }
        if (is_null($dKNumber) || (is_array($dKNumber) && empty($dKNumber))) {
            unset($this->DKNumber);
        } else {
            $this->DKNumber = $dKNumber;
        }
        return $this;
    }
    /**
     * Get Iata value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIata()
    {
        return isset($this->Iata) ? $this->Iata : null;
    }
    /**
     * Set Iata value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iata
     * @return \StructType\ProfileCompanyDefinition
     */
    public function setIata($iata = null)
    {
        // validation for constraint: string
        if (!is_null($iata) && !is_string($iata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iata)), __LINE__);
        }
        if (is_null($iata) || (is_array($iata) && empty($iata))) {
            unset($this->Iata);
        } else {
            $this->Iata = $iata;
        }
        return $this;
    }
    /**
     * Get Image value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProfileImageDefinition|null
     */
    public function getImage()
    {
        return isset($this->Image) ? $this->Image : null;
    }
    /**
     * Set Image value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProfileImageDefinition $image
     * @return \StructType\ProfileCompanyDefinition
     */
    public function setImage(\StructType\ProfileImageDefinition $image = null)
    {
        if (is_null($image) || (is_array($image) && empty($image))) {
            unset($this->Image);
        } else {
            $this->Image = $image;
        }
        return $this;
    }
    /**
     * Get IndustryFieldId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIndustryFieldId()
    {
        return isset($this->IndustryFieldId) ? $this->IndustryFieldId : null;
    }
    /**
     * Set IndustryFieldId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $industryFieldId
     * @return \StructType\ProfileCompanyDefinition
     */
    public function setIndustryFieldId($industryFieldId = null)
    {
        // validation for constraint: string
        if (!is_null($industryFieldId) && !is_string($industryFieldId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($industryFieldId)), __LINE__);
        }
        if (is_null($industryFieldId) || (is_array($industryFieldId) && empty($industryFieldId))) {
            unset($this->IndustryFieldId);
        } else {
            $this->IndustryFieldId = $industryFieldId;
        }
        return $this;
    }
    /**
     * Get IsCorporate value
     * @return bool|null
     */
    public function getIsCorporate()
    {
        return $this->IsCorporate;
    }
    /**
     * Set IsCorporate value
     * @param bool $isCorporate
     * @return \StructType\ProfileCompanyDefinition
     */
    public function setIsCorporate($isCorporate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCorporate) && !is_bool($isCorporate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCorporate)), __LINE__);
        }
        $this->IsCorporate = $isCorporate;
        return $this;
    }
    /**
     * Get IsPrivateBranch value
     * @return bool|null
     */
    public function getIsPrivateBranch()
    {
        return $this->IsPrivateBranch;
    }
    /**
     * Set IsPrivateBranch value
     * @param bool $isPrivateBranch
     * @return \StructType\ProfileCompanyDefinition
     */
    public function setIsPrivateBranch($isPrivateBranch = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrivateBranch) && !is_bool($isPrivateBranch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPrivateBranch)), __LINE__);
        }
        $this->IsPrivateBranch = $isPrivateBranch;
        return $this;
    }
    /**
     * Get LegalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLegalName()
    {
        return isset($this->LegalName) ? $this->LegalName : null;
    }
    /**
     * Set LegalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $legalName
     * @return \StructType\ProfileCompanyDefinition
     */
    public function setLegalName($legalName = null)
    {
        // validation for constraint: string
        if (!is_null($legalName) && !is_string($legalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($legalName)), __LINE__);
        }
        if (is_null($legalName) || (is_array($legalName) && empty($legalName))) {
            unset($this->LegalName);
        } else {
            $this->LegalName = $legalName;
        }
        return $this;
    }
    /**
     * Get Pcc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPcc()
    {
        return isset($this->Pcc) ? $this->Pcc : null;
    }
    /**
     * Set Pcc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pcc
     * @return \StructType\ProfileCompanyDefinition
     */
    public function setPcc($pcc = null)
    {
        // validation for constraint: string
        if (!is_null($pcc) && !is_string($pcc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pcc)), __LINE__);
        }
        if (is_null($pcc) || (is_array($pcc) && empty($pcc))) {
            unset($this->Pcc);
        } else {
            $this->Pcc = $pcc;
        }
        return $this;
    }
    /**
     * Get Queue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueue()
    {
        return isset($this->Queue) ? $this->Queue : null;
    }
    /**
     * Set Queue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queue
     * @return \StructType\ProfileCompanyDefinition
     */
    public function setQueue($queue = null)
    {
        // validation for constraint: string
        if (!is_null($queue) && !is_string($queue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queue)), __LINE__);
        }
        if (is_null($queue) || (is_array($queue) && empty($queue))) {
            unset($this->Queue);
        } else {
            $this->Queue = $queue;
        }
        return $this;
    }
    /**
     * Get TerminalDataList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTerminalDataDefinition|null
     */
    public function getTerminalDataList()
    {
        return isset($this->TerminalDataList) ? $this->TerminalDataList : null;
    }
    /**
     * Set TerminalDataList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTerminalDataDefinition $terminalDataList
     * @return \StructType\ProfileCompanyDefinition
     */
    public function setTerminalDataList(\ArrayType\ArrayOfTerminalDataDefinition $terminalDataList = null)
    {
        if (is_null($terminalDataList) || (is_array($terminalDataList) && empty($terminalDataList))) {
            unset($this->TerminalDataList);
        } else {
            $this->TerminalDataList = $terminalDataList;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProfileCompanyDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
