<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductPriceDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProductPriceDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ProductPriceDefinition extends AbstractStructBase
{
    /**
     * The ActionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActionType;
    /**
     * The AgencyCommision
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PercentageAmountDefinition
     */
    public $AgencyCommision;
    /**
     * The Discounts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDiscountDefinition
     */
    public $Discounts;
    /**
     * The Fees
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProductFeeDefinition
     */
    public $Fees;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CurrencyAmountDefinition
     */
    public $Price;
    /**
     * The SalesCommision
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PercentageAmountDefinition
     */
    public $SalesCommision;
    /**
     * The Surcharges
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CurrencyAmountDefinition
     */
    public $Surcharges;
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProductTaxDefinition
     */
    public $Taxes;
    /**
     * Constructor method for ProductPriceDefinition
     * @uses ProductPriceDefinition::setActionType()
     * @uses ProductPriceDefinition::setAgencyCommision()
     * @uses ProductPriceDefinition::setDiscounts()
     * @uses ProductPriceDefinition::setFees()
     * @uses ProductPriceDefinition::setId()
     * @uses ProductPriceDefinition::setPrice()
     * @uses ProductPriceDefinition::setSalesCommision()
     * @uses ProductPriceDefinition::setSurcharges()
     * @uses ProductPriceDefinition::setTaxes()
     * @param string $actionType
     * @param \StructType\PercentageAmountDefinition $agencyCommision
     * @param \ArrayType\ArrayOfDiscountDefinition $discounts
     * @param \ArrayType\ArrayOfProductFeeDefinition $fees
     * @param int $id
     * @param \StructType\CurrencyAmountDefinition $price
     * @param \StructType\PercentageAmountDefinition $salesCommision
     * @param \StructType\CurrencyAmountDefinition $surcharges
     * @param \ArrayType\ArrayOfProductTaxDefinition $taxes
     */
    public function __construct($actionType = null, \StructType\PercentageAmountDefinition $agencyCommision = null, \ArrayType\ArrayOfDiscountDefinition $discounts = null, \ArrayType\ArrayOfProductFeeDefinition $fees = null, $id = null, \StructType\CurrencyAmountDefinition $price = null, \StructType\PercentageAmountDefinition $salesCommision = null, \StructType\CurrencyAmountDefinition $surcharges = null, \ArrayType\ArrayOfProductTaxDefinition $taxes = null)
    {
        $this
            ->setActionType($actionType)
            ->setAgencyCommision($agencyCommision)
            ->setDiscounts($discounts)
            ->setFees($fees)
            ->setId($id)
            ->setPrice($price)
            ->setSalesCommision($salesCommision)
            ->setSurcharges($surcharges)
            ->setTaxes($taxes);
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\ProductPriceDefinition
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $actionType, implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get AgencyCommision value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PercentageAmountDefinition|null
     */
    public function getAgencyCommision()
    {
        return isset($this->AgencyCommision) ? $this->AgencyCommision : null;
    }
    /**
     * Set AgencyCommision value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PercentageAmountDefinition $agencyCommision
     * @return \StructType\ProductPriceDefinition
     */
    public function setAgencyCommision(\StructType\PercentageAmountDefinition $agencyCommision = null)
    {
        if (is_null($agencyCommision) || (is_array($agencyCommision) && empty($agencyCommision))) {
            unset($this->AgencyCommision);
        } else {
            $this->AgencyCommision = $agencyCommision;
        }
        return $this;
    }
    /**
     * Get Discounts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDiscountDefinition|null
     */
    public function getDiscounts()
    {
        return isset($this->Discounts) ? $this->Discounts : null;
    }
    /**
     * Set Discounts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDiscountDefinition $discounts
     * @return \StructType\ProductPriceDefinition
     */
    public function setDiscounts(\ArrayType\ArrayOfDiscountDefinition $discounts = null)
    {
        if (is_null($discounts) || (is_array($discounts) && empty($discounts))) {
            unset($this->Discounts);
        } else {
            $this->Discounts = $discounts;
        }
        return $this;
    }
    /**
     * Get Fees value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProductFeeDefinition|null
     */
    public function getFees()
    {
        return isset($this->Fees) ? $this->Fees : null;
    }
    /**
     * Set Fees value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProductFeeDefinition $fees
     * @return \StructType\ProductPriceDefinition
     */
    public function setFees(\ArrayType\ArrayOfProductFeeDefinition $fees = null)
    {
        if (is_null($fees) || (is_array($fees) && empty($fees))) {
            unset($this->Fees);
        } else {
            $this->Fees = $fees;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\ProductPriceDefinition
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CurrencyAmountDefinition|null
     */
    public function getPrice()
    {
        return isset($this->Price) ? $this->Price : null;
    }
    /**
     * Set Price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CurrencyAmountDefinition $price
     * @return \StructType\ProductPriceDefinition
     */
    public function setPrice(\StructType\CurrencyAmountDefinition $price = null)
    {
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->Price);
        } else {
            $this->Price = $price;
        }
        return $this;
    }
    /**
     * Get SalesCommision value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PercentageAmountDefinition|null
     */
    public function getSalesCommision()
    {
        return isset($this->SalesCommision) ? $this->SalesCommision : null;
    }
    /**
     * Set SalesCommision value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PercentageAmountDefinition $salesCommision
     * @return \StructType\ProductPriceDefinition
     */
    public function setSalesCommision(\StructType\PercentageAmountDefinition $salesCommision = null)
    {
        if (is_null($salesCommision) || (is_array($salesCommision) && empty($salesCommision))) {
            unset($this->SalesCommision);
        } else {
            $this->SalesCommision = $salesCommision;
        }
        return $this;
    }
    /**
     * Get Surcharges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CurrencyAmountDefinition|null
     */
    public function getSurcharges()
    {
        return isset($this->Surcharges) ? $this->Surcharges : null;
    }
    /**
     * Set Surcharges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CurrencyAmountDefinition $surcharges
     * @return \StructType\ProductPriceDefinition
     */
    public function setSurcharges(\StructType\CurrencyAmountDefinition $surcharges = null)
    {
        if (is_null($surcharges) || (is_array($surcharges) && empty($surcharges))) {
            unset($this->Surcharges);
        } else {
            $this->Surcharges = $surcharges;
        }
        return $this;
    }
    /**
     * Get Taxes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProductTaxDefinition|null
     */
    public function getTaxes()
    {
        return isset($this->Taxes) ? $this->Taxes : null;
    }
    /**
     * Set Taxes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProductTaxDefinition $taxes
     * @return \StructType\ProductPriceDefinition
     */
    public function setTaxes(\ArrayType\ArrayOfProductTaxDefinition $taxes = null)
    {
        if (is_null($taxes) || (is_array($taxes) && empty($taxes))) {
            unset($this->Taxes);
        } else {
            $this->Taxes = $taxes;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductPriceDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
