<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelRoomNightPriceDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:HotelRoomNightPriceDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class HotelRoomNightPriceDefinition extends AbstractStructBase
{
    /**
     * The Cost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Cost;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Price;
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Taxes;
    /**
     * Constructor method for HotelRoomNightPriceDefinition
     * @uses HotelRoomNightPriceDefinition::setCost()
     * @uses HotelRoomNightPriceDefinition::setDate()
     * @uses HotelRoomNightPriceDefinition::setPrice()
     * @uses HotelRoomNightPriceDefinition::setTaxes()
     * @param float $cost
     * @param string $date
     * @param float $price
     * @param float $taxes
     */
    public function __construct($cost = null, $date = null, $price = null, $taxes = null)
    {
        $this
            ->setCost($cost)
            ->setDate($date)
            ->setPrice($price)
            ->setTaxes($taxes);
    }
    /**
     * Get Cost value
     * @return float|null
     */
    public function getCost()
    {
        return $this->Cost;
    }
    /**
     * Set Cost value
     * @param float $cost
     * @return \StructType\HotelRoomNightPriceDefinition
     */
    public function setCost($cost = null)
    {
        $this->Cost = $cost;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\HotelRoomNightPriceDefinition
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\HotelRoomNightPriceDefinition
     */
    public function setPrice($price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Taxes value
     * @return float|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param float $taxes
     * @return \StructType\HotelRoomNightPriceDefinition
     */
    public function setTaxes($taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelRoomNightPriceDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
