<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityChangesHistoryDetailDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:EntityChangesHistoryDetailDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class EntityChangesHistoryDetailDefinition extends AbstractStructBase
{
    /**
     * The EntityChangesHistoryId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EntityChangesHistoryId;
    /**
     * The Field
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Field;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The NewValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewValue;
    /**
     * The OldValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OldValue;
    /**
     * Constructor method for EntityChangesHistoryDetailDefinition
     * @uses EntityChangesHistoryDetailDefinition::setEntityChangesHistoryId()
     * @uses EntityChangesHistoryDetailDefinition::setField()
     * @uses EntityChangesHistoryDetailDefinition::setId()
     * @uses EntityChangesHistoryDetailDefinition::setNewValue()
     * @uses EntityChangesHistoryDetailDefinition::setOldValue()
     * @param int $entityChangesHistoryId
     * @param string $field
     * @param int $id
     * @param string $newValue
     * @param string $oldValue
     */
    public function __construct($entityChangesHistoryId = null, $field = null, $id = null, $newValue = null, $oldValue = null)
    {
        $this
            ->setEntityChangesHistoryId($entityChangesHistoryId)
            ->setField($field)
            ->setId($id)
            ->setNewValue($newValue)
            ->setOldValue($oldValue);
    }
    /**
     * Get EntityChangesHistoryId value
     * @return int|null
     */
    public function getEntityChangesHistoryId()
    {
        return $this->EntityChangesHistoryId;
    }
    /**
     * Set EntityChangesHistoryId value
     * @param int $entityChangesHistoryId
     * @return \StructType\EntityChangesHistoryDetailDefinition
     */
    public function setEntityChangesHistoryId($entityChangesHistoryId = null)
    {
        // validation for constraint: int
        if (!is_null($entityChangesHistoryId) && !is_numeric($entityChangesHistoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($entityChangesHistoryId)), __LINE__);
        }
        $this->EntityChangesHistoryId = $entityChangesHistoryId;
        return $this;
    }
    /**
     * Get Field value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getField()
    {
        return isset($this->Field) ? $this->Field : null;
    }
    /**
     * Set Field value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $field
     * @return \StructType\EntityChangesHistoryDetailDefinition
     */
    public function setField($field = null)
    {
        // validation for constraint: string
        if (!is_null($field) && !is_string($field)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field)), __LINE__);
        }
        if (is_null($field) || (is_array($field) && empty($field))) {
            unset($this->Field);
        } else {
            $this->Field = $field;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\EntityChangesHistoryDetailDefinition
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get NewValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewValue()
    {
        return isset($this->NewValue) ? $this->NewValue : null;
    }
    /**
     * Set NewValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newValue
     * @return \StructType\EntityChangesHistoryDetailDefinition
     */
    public function setNewValue($newValue = null)
    {
        // validation for constraint: string
        if (!is_null($newValue) && !is_string($newValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newValue)), __LINE__);
        }
        if (is_null($newValue) || (is_array($newValue) && empty($newValue))) {
            unset($this->NewValue);
        } else {
            $this->NewValue = $newValue;
        }
        return $this;
    }
    /**
     * Get OldValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldValue()
    {
        return isset($this->OldValue) ? $this->OldValue : null;
    }
    /**
     * Set OldValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldValue
     * @return \StructType\EntityChangesHistoryDetailDefinition
     */
    public function setOldValue($oldValue = null)
    {
        // validation for constraint: string
        if (!is_null($oldValue) && !is_string($oldValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oldValue)), __LINE__);
        }
        if (is_null($oldValue) || (is_array($oldValue) && empty($oldValue))) {
            unset($this->OldValue);
        } else {
            $this->OldValue = $oldValue;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EntityChangesHistoryDetailDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
