<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrencyAmountDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CurrencyAmountDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class CurrencyAmountDefinition extends AbstractStructBase
{
    /**
     * The ActionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActionType;
    /**
     * The BaseAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BaseAmount;
    /**
     * The BaseCurrencyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BaseCurrencyCode;
    /**
     * The EquivalentAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $EquivalentAmount;
    /**
     * The EquivalentCurrencyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EquivalentCurrencyCode;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The RateOfExchange
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $RateOfExchange;
    /**
     * Constructor method for CurrencyAmountDefinition
     * @uses CurrencyAmountDefinition::setActionType()
     * @uses CurrencyAmountDefinition::setBaseAmount()
     * @uses CurrencyAmountDefinition::setBaseCurrencyCode()
     * @uses CurrencyAmountDefinition::setEquivalentAmount()
     * @uses CurrencyAmountDefinition::setEquivalentCurrencyCode()
     * @uses CurrencyAmountDefinition::setId()
     * @uses CurrencyAmountDefinition::setRateOfExchange()
     * @param string $actionType
     * @param float $baseAmount
     * @param string $baseCurrencyCode
     * @param float $equivalentAmount
     * @param string $equivalentCurrencyCode
     * @param int $id
     * @param float $rateOfExchange
     */
    public function __construct($actionType = null, $baseAmount = null, $baseCurrencyCode = null, $equivalentAmount = null, $equivalentCurrencyCode = null, $id = null, $rateOfExchange = null)
    {
        $this
            ->setActionType($actionType)
            ->setBaseAmount($baseAmount)
            ->setBaseCurrencyCode($baseCurrencyCode)
            ->setEquivalentAmount($equivalentAmount)
            ->setEquivalentCurrencyCode($equivalentCurrencyCode)
            ->setId($id)
            ->setRateOfExchange($rateOfExchange);
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\CurrencyAmountDefinition
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $actionType, implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get BaseAmount value
     * @return float|null
     */
    public function getBaseAmount()
    {
        return $this->BaseAmount;
    }
    /**
     * Set BaseAmount value
     * @param float $baseAmount
     * @return \StructType\CurrencyAmountDefinition
     */
    public function setBaseAmount($baseAmount = null)
    {
        $this->BaseAmount = $baseAmount;
        return $this;
    }
    /**
     * Get BaseCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBaseCurrencyCode()
    {
        return isset($this->BaseCurrencyCode) ? $this->BaseCurrencyCode : null;
    }
    /**
     * Set BaseCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $baseCurrencyCode
     * @return \StructType\CurrencyAmountDefinition
     */
    public function setBaseCurrencyCode($baseCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($baseCurrencyCode) && !is_string($baseCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baseCurrencyCode)), __LINE__);
        }
        if (is_null($baseCurrencyCode) || (is_array($baseCurrencyCode) && empty($baseCurrencyCode))) {
            unset($this->BaseCurrencyCode);
        } else {
            $this->BaseCurrencyCode = $baseCurrencyCode;
        }
        return $this;
    }
    /**
     * Get EquivalentAmount value
     * @return float|null
     */
    public function getEquivalentAmount()
    {
        return $this->EquivalentAmount;
    }
    /**
     * Set EquivalentAmount value
     * @param float $equivalentAmount
     * @return \StructType\CurrencyAmountDefinition
     */
    public function setEquivalentAmount($equivalentAmount = null)
    {
        $this->EquivalentAmount = $equivalentAmount;
        return $this;
    }
    /**
     * Get EquivalentCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEquivalentCurrencyCode()
    {
        return isset($this->EquivalentCurrencyCode) ? $this->EquivalentCurrencyCode : null;
    }
    /**
     * Set EquivalentCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $equivalentCurrencyCode
     * @return \StructType\CurrencyAmountDefinition
     */
    public function setEquivalentCurrencyCode($equivalentCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($equivalentCurrencyCode) && !is_string($equivalentCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($equivalentCurrencyCode)), __LINE__);
        }
        if (is_null($equivalentCurrencyCode) || (is_array($equivalentCurrencyCode) && empty($equivalentCurrencyCode))) {
            unset($this->EquivalentCurrencyCode);
        } else {
            $this->EquivalentCurrencyCode = $equivalentCurrencyCode;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\CurrencyAmountDefinition
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get RateOfExchange value
     * @return float|null
     */
    public function getRateOfExchange()
    {
        return $this->RateOfExchange;
    }
    /**
     * Set RateOfExchange value
     * @param float $rateOfExchange
     * @return \StructType\CurrencyAmountDefinition
     */
    public function setRateOfExchange($rateOfExchange = null)
    {
        $this->RateOfExchange = $rateOfExchange;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CurrencyAmountDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
