<?php

namespace EnumType;

/**
 * This class stands for TerminalPreferencesType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TerminalPreferencesType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class TerminalPreferencesType
{
    /**
     * Constant for value 'Function'
     * @return string 'Function'
     */
    const VALUE_FUNCTION = 'Function';
    /**
     * Constant for value 'HotKey'
     * @return string 'HotKey'
     */
    const VALUE_HOT_KEY = 'HotKey';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FUNCTION
     * @uses self::VALUE_HOT_KEY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FUNCTION,
            self::VALUE_HOT_KEY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
