<?php

namespace EnumType;

/**
 * This class stands for ResevationPaymentStatusType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ResevationPaymentStatusType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ResevationPaymentStatusType
{
    /**
     * Constant for value 'NotPaid'
     * @return string 'NotPaid'
     */
    const VALUE_NOT_PAID = 'NotPaid';
    /**
     * Constant for value 'Paid'
     * @return string 'Paid'
     */
    const VALUE_PAID = 'Paid';
    /**
     * Constant for value 'PendingConfirmation'
     * @return string 'PendingConfirmation'
     */
    const VALUE_PENDING_CONFIRMATION = 'PendingConfirmation';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_PAID
     * @uses self::VALUE_PAID
     * @uses self::VALUE_PENDING_CONFIRMATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_PAID,
            self::VALUE_PAID,
            self::VALUE_PENDING_CONFIRMATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
