<?php

namespace EnumType;

/**
 * This class stands for PaymentFormType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentFormType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class PaymentFormType
{
    /**
     * Constant for value 'Cash'
     * @return string 'Cash'
     */
    const VALUE_CASH = 'Cash';
    /**
     * Constant for value 'CreditCard'
     * @return string 'CreditCard'
     */
    const VALUE_CREDIT_CARD = 'CreditCard';
    /**
     * Constant for value 'Check'
     * @return string 'Check'
     */
    const VALUE_CHECK = 'Check';
    /**
     * Constant for value 'PTA'
     * @return string 'PTA'
     */
    const VALUE_PTA = 'PTA';
    /**
     * Constant for value 'CreditAndCash'
     * @return string 'CreditAndCash'
     */
    const VALUE_CREDIT_AND_CASH = 'CreditAndCash';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CASH
     * @uses self::VALUE_CREDIT_CARD
     * @uses self::VALUE_CHECK
     * @uses self::VALUE_PTA
     * @uses self::VALUE_CREDIT_AND_CASH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CASH,
            self::VALUE_CREDIT_CARD,
            self::VALUE_CHECK,
            self::VALUE_PTA,
            self::VALUE_CREDIT_AND_CASH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
