<?php

namespace EnumType;

/**
 * This class stands for GuaranteeType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GuaranteeType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class GuaranteeType
{
    /**
     * Constant for value 'NotRequired'
     * @return string 'NotRequired'
     */
    const VALUE_NOT_REQUIRED = 'NotRequired';
    /**
     * Constant for value 'PrePaid'
     * @return string 'PrePaid'
     */
    const VALUE_PRE_PAID = 'PrePaid';
    /**
     * Constant for value 'CreditCard'
     * @return string 'CreditCard'
     */
    const VALUE_CREDIT_CARD = 'CreditCard';
    /**
     * Constant for value 'Deposit'
     * @return string 'Deposit'
     */
    const VALUE_DEPOSIT = 'Deposit';
    /**
     * Constant for value 'UpfrontCommission'
     * @return string 'UpfrontCommission'
     */
    const VALUE_UPFRONT_COMMISSION = 'UpfrontCommission';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_REQUIRED
     * @uses self::VALUE_PRE_PAID
     * @uses self::VALUE_CREDIT_CARD
     * @uses self::VALUE_DEPOSIT
     * @uses self::VALUE_UPFRONT_COMMISSION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_REQUIRED,
            self::VALUE_PRE_PAID,
            self::VALUE_CREDIT_CARD,
            self::VALUE_DEPOSIT,
            self::VALUE_UPFRONT_COMMISSION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
