<?php

namespace EnumType;

/**
 * This class stands for DepositInfoType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DepositInfoType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class DepositInfoType
{
    /**
     * Constant for value 'FirstNight'
     * @return string 'FirstNight'
     */
    const VALUE_FIRST_NIGHT = 'FirstNight';
    /**
     * Constant for value 'Fixed'
     * @return string 'Fixed'
     */
    const VALUE_FIXED = 'Fixed';
    /**
     * Constant for value 'Percentage'
     * @return string 'Percentage'
     */
    const VALUE_PERCENTAGE = 'Percentage';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FIRST_NIGHT
     * @uses self::VALUE_FIXED
     * @uses self::VALUE_PERCENTAGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FIRST_NIGHT,
            self::VALUE_FIXED,
            self::VALUE_PERCENTAGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
