<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRoomOptionDefinition ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRoomOptionDefinition
 * @subpackage Arrays
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ArrayOfRoomOptionDefinition extends AbstractStructArrayBase
{
    /**
     * The RoomOptionDefinition
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RoomOptionDefinition[]
     */
    public $RoomOptionDefinition;
    /**
     * Constructor method for ArrayOfRoomOptionDefinition
     * @uses ArrayOfRoomOptionDefinition::setRoomOptionDefinition()
     * @param \StructType\RoomOptionDefinition[] $roomOptionDefinition
     */
    public function __construct(array $roomOptionDefinition = array())
    {
        $this
            ->setRoomOptionDefinition($roomOptionDefinition);
    }
    /**
     * Get RoomOptionDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RoomOptionDefinition[]|null
     */
    public function getRoomOptionDefinition()
    {
        return isset($this->RoomOptionDefinition) ? $this->RoomOptionDefinition : null;
    }
    /**
     * Set RoomOptionDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RoomOptionDefinition[] $roomOptionDefinition
     * @return \ArrayType\ArrayOfRoomOptionDefinition
     */
    public function setRoomOptionDefinition(array $roomOptionDefinition = array())
    {
        foreach ($roomOptionDefinition as $arrayOfRoomOptionDefinitionRoomOptionDefinitionItem) {
            // validation for constraint: itemType
            if (!$arrayOfRoomOptionDefinitionRoomOptionDefinitionItem instanceof \StructType\RoomOptionDefinition) {
                throw new \InvalidArgumentException(sprintf('The RoomOptionDefinition property can only contain items of \StructType\RoomOptionDefinition, "%s" given', is_object($arrayOfRoomOptionDefinitionRoomOptionDefinitionItem) ? get_class($arrayOfRoomOptionDefinitionRoomOptionDefinitionItem) : gettype($arrayOfRoomOptionDefinitionRoomOptionDefinitionItem)), __LINE__);
            }
        }
        if (is_null($roomOptionDefinition) || (is_array($roomOptionDefinition) && empty($roomOptionDefinition))) {
            unset($this->RoomOptionDefinition);
        } else {
            $this->RoomOptionDefinition = $roomOptionDefinition;
        }
        return $this;
    }
    /**
     * Add item to RoomOptionDefinition value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomOptionDefinition $item
     * @return \ArrayType\ArrayOfRoomOptionDefinition
     */
    public function addToRoomOptionDefinition(\StructType\RoomOptionDefinition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomOptionDefinition) {
            throw new \InvalidArgumentException(sprintf('The RoomOptionDefinition property can only contain items of \StructType\RoomOptionDefinition, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoomOptionDefinition[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RoomOptionDefinition|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RoomOptionDefinition|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RoomOptionDefinition|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RoomOptionDefinition|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RoomOptionDefinition|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RoomOptionDefinition
     */
    public function getAttributeName()
    {
        return 'RoomOptionDefinition';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRoomOptionDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
