<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KYCInfo StructType
 * @subpackage Structs
 */
class KYCInfo extends AbstractStructBase
{
    /**
     * The KYCName
     * Meta informations extracted from the WSDL
     * - maxLength: 255
     * @var string
     */
    public $KYCName;
    /**
     * The KYCValue
     * Meta informations extracted from the WSDL
     * - maxLength: 128
     * @var string
     */
    public $KYCValue;
    /**
     * Constructor method for KYCInfo
     * @uses KYCInfo::setKYCName()
     * @uses KYCInfo::setKYCValue()
     * @param string $kYCName
     * @param string $kYCValue
     */
    public function __construct($kYCName = null, $kYCValue = null)
    {
        $this
            ->setKYCName($kYCName)
            ->setKYCValue($kYCValue);
    }
    /**
     * Get KYCName value
     * @return string|null
     */
    public function getKYCName()
    {
        return $this->KYCName;
    }
    /**
     * Set KYCName value
     * @param string $kYCName
     * @return \StructType\KYCInfo
     */
    public function setKYCName($kYCName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($kYCName) && strlen($kYCName) > 255) || (is_array($kYCName) && count($kYCName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($kYCName) ? strlen($kYCName) : count($kYCName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kYCName) && !is_string($kYCName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kYCName)), __LINE__);
        }
        $this->KYCName = $kYCName;
        return $this;
    }
    /**
     * Get KYCValue value
     * @return string|null
     */
    public function getKYCValue()
    {
        return $this->KYCValue;
    }
    /**
     * Set KYCValue value
     * @param string $kYCValue
     * @return \StructType\KYCInfo
     */
    public function setKYCValue($kYCValue = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($kYCValue) && strlen($kYCValue) > 128) || (is_array($kYCValue) && count($kYCValue) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($kYCValue) ? strlen($kYCValue) : count($kYCValue)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kYCValue) && !is_string($kYCValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kYCValue)), __LINE__);
        }
        $this->KYCValue = $kYCValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KYCInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
