<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for C2BPaymentValidationRequest StructType
 * @subpackage Structs
 */
class C2BPaymentValidationRequest extends AbstractStructBase
{
    /**
     * The TransType
     * @var string
     */
    public $TransType;
    /**
     * The TransID
     * @var string
     */
    public $TransID;
    /**
     * The TransTime
     * @var string
     */
    public $TransTime;
    /**
     * The TransAmount
     * @var string
     */
    public $TransAmount;
    /**
     * The BusinessShortCode
     * @var string
     */
    public $BusinessShortCode;
    /**
     * The BillRefNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BillRefNumber;
    /**
     * The InvoiceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The MSISDN
     * @var string
     */
    public $MSISDN;
    /**
     * The KYCInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KYCInfo[]
     */
    public $KYCInfo;
    /**
     * Constructor method for C2BPaymentValidationRequest
     * @uses C2BPaymentValidationRequest::setTransType()
     * @uses C2BPaymentValidationRequest::setTransID()
     * @uses C2BPaymentValidationRequest::setTransTime()
     * @uses C2BPaymentValidationRequest::setTransAmount()
     * @uses C2BPaymentValidationRequest::setBusinessShortCode()
     * @uses C2BPaymentValidationRequest::setBillRefNumber()
     * @uses C2BPaymentValidationRequest::setInvoiceNumber()
     * @uses C2BPaymentValidationRequest::setMSISDN()
     * @uses C2BPaymentValidationRequest::setKYCInfo()
     * @param string $transType
     * @param string $transID
     * @param string $transTime
     * @param string $transAmount
     * @param string $businessShortCode
     * @param string $billRefNumber
     * @param string $invoiceNumber
     * @param string $mSISDN
     * @param \StructType\KYCInfo[] $kYCInfo
     */
    public function __construct($transType = null, $transID = null, $transTime = null, $transAmount = null, $businessShortCode = null, $billRefNumber = null, $invoiceNumber = null, $mSISDN = null, array $kYCInfo = array())
    {
        $this
            ->setTransType($transType)
            ->setTransID($transID)
            ->setTransTime($transTime)
            ->setTransAmount($transAmount)
            ->setBusinessShortCode($businessShortCode)
            ->setBillRefNumber($billRefNumber)
            ->setInvoiceNumber($invoiceNumber)
            ->setMSISDN($mSISDN)
            ->setKYCInfo($kYCInfo);
    }
    /**
     * Get TransType value
     * @return string|null
     */
    public function getTransType()
    {
        return $this->TransType;
    }
    /**
     * Set TransType value
     * @param string $transType
     * @return \StructType\C2BPaymentValidationRequest
     */
    public function setTransType($transType = null)
    {
        // validation for constraint: string
        if (!is_null($transType) && !is_string($transType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transType)), __LINE__);
        }
        $this->TransType = $transType;
        return $this;
    }
    /**
     * Get TransID value
     * @return string|null
     */
    public function getTransID()
    {
        return $this->TransID;
    }
    /**
     * Set TransID value
     * @param string $transID
     * @return \StructType\C2BPaymentValidationRequest
     */
    public function setTransID($transID = null)
    {
        // validation for constraint: string
        if (!is_null($transID) && !is_string($transID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transID)), __LINE__);
        }
        $this->TransID = $transID;
        return $this;
    }
    /**
     * Get TransTime value
     * @return string|null
     */
    public function getTransTime()
    {
        return $this->TransTime;
    }
    /**
     * Set TransTime value
     * @param string $transTime
     * @return \StructType\C2BPaymentValidationRequest
     */
    public function setTransTime($transTime = null)
    {
        // validation for constraint: string
        if (!is_null($transTime) && !is_string($transTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transTime)), __LINE__);
        }
        $this->TransTime = $transTime;
        return $this;
    }
    /**
     * Get TransAmount value
     * @return string|null
     */
    public function getTransAmount()
    {
        return $this->TransAmount;
    }
    /**
     * Set TransAmount value
     * @param string $transAmount
     * @return \StructType\C2BPaymentValidationRequest
     */
    public function setTransAmount($transAmount = null)
    {
        // validation for constraint: string
        if (!is_null($transAmount) && !is_string($transAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transAmount)), __LINE__);
        }
        $this->TransAmount = $transAmount;
        return $this;
    }
    /**
     * Get BusinessShortCode value
     * @return string|null
     */
    public function getBusinessShortCode()
    {
        return $this->BusinessShortCode;
    }
    /**
     * Set BusinessShortCode value
     * @param string $businessShortCode
     * @return \StructType\C2BPaymentValidationRequest
     */
    public function setBusinessShortCode($businessShortCode = null)
    {
        // validation for constraint: string
        if (!is_null($businessShortCode) && !is_string($businessShortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($businessShortCode)), __LINE__);
        }
        $this->BusinessShortCode = $businessShortCode;
        return $this;
    }
    /**
     * Get BillRefNumber value
     * @return string|null
     */
    public function getBillRefNumber()
    {
        return $this->BillRefNumber;
    }
    /**
     * Set BillRefNumber value
     * @param string $billRefNumber
     * @return \StructType\C2BPaymentValidationRequest
     */
    public function setBillRefNumber($billRefNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billRefNumber) && !is_string($billRefNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billRefNumber)), __LINE__);
        }
        $this->BillRefNumber = $billRefNumber;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \StructType\C2BPaymentValidationRequest
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get MSISDN value
     * @return string|null
     */
    public function getMSISDN()
    {
        return $this->MSISDN;
    }
    /**
     * Set MSISDN value
     * @param string $mSISDN
     * @return \StructType\C2BPaymentValidationRequest
     */
    public function setMSISDN($mSISDN = null)
    {
        // validation for constraint: string
        if (!is_null($mSISDN) && !is_string($mSISDN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mSISDN)), __LINE__);
        }
        $this->MSISDN = $mSISDN;
        return $this;
    }
    /**
     * Get KYCInfo value
     * @return \StructType\KYCInfo[]|null
     */
    public function getKYCInfo()
    {
        return $this->KYCInfo;
    }
    /**
     * Set KYCInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\KYCInfo[] $kYCInfo
     * @return \StructType\C2BPaymentValidationRequest
     */
    public function setKYCInfo(array $kYCInfo = array())
    {
        foreach ($kYCInfo as $c2BPaymentValidationRequestKYCInfoItem) {
            // validation for constraint: itemType
            if (!$c2BPaymentValidationRequestKYCInfoItem instanceof \StructType\KYCInfo) {
                throw new \InvalidArgumentException(sprintf('The KYCInfo property can only contain items of \StructType\KYCInfo, "%s" given', is_object($c2BPaymentValidationRequestKYCInfoItem) ? get_class($c2BPaymentValidationRequestKYCInfoItem) : gettype($c2BPaymentValidationRequestKYCInfoItem)), __LINE__);
            }
        }
        $this->KYCInfo = $kYCInfo;
        return $this;
    }
    /**
     * Add item to KYCInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\KYCInfo $item
     * @return \StructType\C2BPaymentValidationRequest
     */
    public function addToKYCInfo(\StructType\KYCInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KYCInfo) {
            throw new \InvalidArgumentException(sprintf('The KYCInfo property can only contain items of \StructType\KYCInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->KYCInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\C2BPaymentValidationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
