<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for C2BPaymentValidationResult StructType
 * @subpackage Structs
 */
class C2BPaymentValidationResult extends AbstractStructBase
{
    /**
     * The ResultCode
     * Meta informations extracted from the WSDL
     * - maxLength: 20
     * @var string
     */
    public $ResultCode;
    /**
     * The ResultDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $ResultDesc;
    /**
     * The ThirdPartyTransID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ThirdPartyTransID;
    /**
     * Constructor method for C2BPaymentValidationResult
     * @uses C2BPaymentValidationResult::setResultCode()
     * @uses C2BPaymentValidationResult::setResultDesc()
     * @uses C2BPaymentValidationResult::setThirdPartyTransID()
     * @param string $resultCode
     * @param string $resultDesc
     * @param string $thirdPartyTransID
     */
    public function __construct($resultCode = null, $resultDesc = null, $thirdPartyTransID = null)
    {
        $this
            ->setResultCode($resultCode)
            ->setResultDesc($resultDesc)
            ->setThirdPartyTransID($thirdPartyTransID);
    }
    /**
     * Get ResultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \StructType\C2BPaymentValidationResult
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($resultCode) && strlen($resultCode) > 20) || (is_array($resultCode) && count($resultCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($resultCode) ? strlen($resultCode) : count($resultCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get ResultDesc value
     * @return string|null
     */
    public function getResultDesc()
    {
        return $this->ResultDesc;
    }
    /**
     * Set ResultDesc value
     * @param string $resultDesc
     * @return \StructType\C2BPaymentValidationResult
     */
    public function setResultDesc($resultDesc = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($resultDesc) && strlen($resultDesc) > 1024) || (is_array($resultDesc) && count($resultDesc) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($resultDesc) ? strlen($resultDesc) : count($resultDesc)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($resultDesc) && !is_string($resultDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resultDesc)), __LINE__);
        }
        $this->ResultDesc = $resultDesc;
        return $this;
    }
    /**
     * Get ThirdPartyTransID value
     * @return string|null
     */
    public function getThirdPartyTransID()
    {
        return $this->ThirdPartyTransID;
    }
    /**
     * Set ThirdPartyTransID value
     * @param string $thirdPartyTransID
     * @return \StructType\C2BPaymentValidationResult
     */
    public function setThirdPartyTransID($thirdPartyTransID = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyTransID) && !is_string($thirdPartyTransID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($thirdPartyTransID)), __LINE__);
        }
        $this->ThirdPartyTransID = $thirdPartyTransID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\C2BPaymentValidationResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
